function res = test_nn_rl_RLagent_validateOptions()
% test_nn_rl_RLagent_validateOptions - unit test function for
%     RLagents/@RLagent: checks coorect options validation.
%
% Syntax:
%    res = test_nn_rl_RLagent_validateOptions()
%
% Inputs:
%    -
%
% Outputs:
%    res - true/false
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also:

% Authors:       Manuel Wendl
% Written:       27-August-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% Build NNs ---------------------------------------------------------------

% Actor NN 
actorLayers = [
    featureInputLayer(2)
    fullyConnectedLayer(64)
    reluLayer
    fullyConnectedLayer(32)
    reluLayer
    fullyConnectedLayer(1)
    tanhLayer
    ];

% Critic NN 
criticLayers = [
    featureInputLayer(3)
    fullyConnectedLayer(64)
    reluLayer
    fullyConnectedLayer(32)
    reluLayer
    fullyConnectedLayer(1)
    ];

% initialize weights and biases of the layers
actorInit = dlnetwork(actorLayers);
nnActor = neuralNetwork.convertDLToolboxNetwork(num2cell(actorInit.Layers),false);

% initialize weights and biases of the layers
criticInit = dlnetwork(criticLayers);
nnCritic = neuralNetwork.convertDLToolboxNetwork(num2cell(criticInit.Layers),false);

% Test wrong combination for set-based critic
options.rl.critic.nn.train.method = 'naive';
options.rl.actor.nn.train.method = 'point';

try
    agent = DDPGagent(nnActor,nnCritic,options);
    res1 = false;
catch
    res1 = true;
end

options.rl.critic.nn.train.method = 'grad';
options.rl.actor.nn.train.method = 'point';

try
    agent = DDPGagent(nnActor,nnCritic,options);
    res1 = res1 && false;
catch
    res1 = res1 && true;
end

options.rl.critic.nn.train.method = 'set';
options.rl.actor.nn.train.method = 'point';

try
    agent = DDPGagent(nnActor,nnCritic,options);
    res1 = res1 && false;
catch
    res1 = res1 && true;
end

options.rl.critic.nn.train.method = 'set';
options.rl.actor.nn.train.method = 'naive';

try
    agent = DDPGagent(nnActor,nnCritic,options);
    res1 = res1 && false;
catch
    res1 = res1 && true;
end

options.rl.critic.nn.train.method = 'set';
options.rl.actor.nn.train.method = 'grad';

try
    agent = DDPGagent(nnActor,nnCritic,options);
    res1 = res1 && false;
catch
    res1 = res1 && true;
end

% Test wrong type of propagation etchnique
options.rl.critic.nn.train.method = 'set';
options.rl.actor.nn.train.method = 'set';
options.rl.actor.nn.poly_method = 'regression';

try
    agent = DDPGagent(nnActor,nnCritic,options);
    res2 = false;
catch
    res2 = true;
end

% Test wrong value for noise 
options.rl.actor.nn.poly_method = 'bounds';
options.rl.noise = -1;

try
    agent = DDPGagent(nnActor,nnCritic,options);
    res3 = false;
catch
    res3 = true;
end

% Test wrong value for gamma 
options.rl.noise = .1;
options.rl.gamma = 2;

try
    agent = DDPGagent(nnActor,nnCritic,options);
    res4 = false;
catch
    res4 = true;
end

% Test wrong Exploration Noise 
options.rl.gamma = .1;
options.rl.expNoiseType = 'Laplace';
options.rl.expNoise = -0.1;

try
    agent = DDPGagent(nnActor,nnCritic,options);
    res5 = false;
catch
    res5 = true;
end

% Test wrong perturbation noise dimension
options.rl.expNoiseType = 'OU';
options.rl.expNoise = 0.1;
options.rl.noise = eye(2);

try
    agent = DDPGagent(nnActor,nnCritic,options);
    res5 = false;
catch
    res5 = true;
end

res = all([res1,res2,res3,res4,res5]);

end

% ------------------------------ END OF CODE ------------------------------
