function res = test_nn_rl_ctrlEnv_validateOptions()
% test_nn_rl_ctrlEnv_validateOptions - unit test function for
%     @ctrlEnvironment/ctrlEnvironment: Check given options are validated
%     correctly.
%
% Syntax:
%    res = test_nn_rl_ctrlEnv_validateOptions()
%
% Inputs:
%    -
%
% Outputs:
%    res - true/false
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also:

% Authors:       Manuel Wendl
% Written:       27-August-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% System Dynamics ---------------------------------------------------------
m = 0.05;
g = 9.81;
% open-loop system
f = @(x,u) [x(2);(u(1)+1)/(2*m)-g];
sys = contDynamics('Name',1,2);

try
    env = ctrlEnvironment(sys,@aux_rewardFun_Quadrocopter1D,@aux_collisionCheck_Quadrocopter1D,options);
    res1 = false;
catch
    res1 = true;
end

sys = nonlinearSys(f);
options.rl.env.x0 = [[-4;0],[4;0]];

try
    env = ctrlEnvironment(sys,@aux_rewardFun_Quadrocopter1D,@aux_collisionCheck_Quadrocopter1D,options);
    res2 = false;
catch
    res2 = true;
end

options.rl.env.x0 = interval([-4;0],[4;0]);
options.rl.env.initialOps = 'None';

env = ctrlEnvironment(sys,@aux_rewardFun_Quadrocopter1D,@aux_collisionCheck_Quadrocopter1D,options);
[~, observation] = env.reset();

if all(observation == [0;0])
    res3 = true;
else
    res3 = false;
end

options.rl.env.initialOps = 'inf';

env = ctrlEnvironment(sys,@aux_rewardFun_Quadrocopter1D,@aux_collisionCheck_Quadrocopter1D,options);
[~, observation] = env.reset();

if all(observation == options.rl.env.x0.inf)
    res3 = res3 && true;
else
    res3 = res3 && false;
end

options.rl.env.initialOps = 'sup';

env = ctrlEnvironment(sys,@aux_rewardFun_Quadrocopter1D,@aux_collisionCheck_Quadrocopter1D,options);
[~, observation] = env.reset();

if all(observation == options.rl.env.x0.sup)
    res3 = res3 && true;
else
    res3 = res3 && false;
end

options.rl.env.dt = .1;
options.rl.env.timeStep = .2;

try
    env = ctrlEnvironment(sys,@aux_rewardFun_Quadrocopter1D,@aux_collisionCheck_Quadrocopter1D,options);
    res4 = false;
catch
    res4 = true;
end

options.rl.env.timeStep = .02;
options.rl.env.maxSteps = 0;

try
    env = ctrlEnvironment(sys,@aux_rewardFun_Quadrocopter1D,@aux_collisionCheck_Quadrocopter1D,options);
    res5 = false;
catch
    res5 = true;
end

options.rl.env.maxSteps = 30;
options.rl.env.evalMode = 'point';

env = ctrlEnvironment(sys,@aux_rewardFun_Quadrocopter1D,@aux_collisionCheck_Quadrocopter1D,options);
[~, observation] = env.reset();

if isnumeric(observation)
    res6 = true;
else
    res6 = false;
end

options.rl.env.evalMode = 'set';

env = ctrlEnvironment(sys,@aux_rewardFun_Quadrocopter1D,@aux_collisionCheck_Quadrocopter1D,options);
[~, observation] = env.reset();

if isa(observation,'zonotope')
    res7 = true;
else
    res7 = false;
end

res = all([res1,res2,res3,res4,res5,res6,res7]);

end


% Auxiliary functions -----------------------------------------------------

function reward = aux_rewardFun_Quadrocopter1D(x)
if isnumeric(x)
    reward = -(abs(x(end,1))+0.01*abs(x(end,2)));
else
    w = [1,0.01,0];
    reward = -max(abs(supportFunc(x.timePoint.set{end},w,'lower')),abs(supportFunc(x.timePoint.set{end},w)));
end
end

function collisionBool = aux_collisionCheck_Quadrocopter1D(x)
if isa(x,'numeric')
    if all(abs(x(:,1:2))<0.05,"all")
        collisionBool = true;
    else
        collisionBool = false;
    end
elseif isa(x,'reachSet')
    if norm(x.timePoint.set{1}.c)<0.05
        collisionBool = true;
    else
        collisionBool = false;
    end
end
end

% ------------------------------ END OF CODE ------------------------------
