function res = test_fourValued
% test_fourValued - unit test function of fourValued
%
% Syntax:
%    res = test_fourValued
%
% Inputs:
%    -
%
% Outputs:
%    res - true/false
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       Florian Lercher
% Written:       21-February-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

res = false(0);

% abbreviations for enum members
tt = fourValued.True;
uu = fourValued.Unknown;
ff = fourValued.False;
ii = fourValued.Inconclusive;

% conjunction
res(end+1) = isequal(tt & tt, tt);
res(end+1) = isequal(tt & uu, uu);
res(end+1) = isequal(tt & ff, ff);
res(end+1) = isequal(tt & ii, ii);
res(end+1) = isequal(uu & tt, uu);
res(end+1) = isequal(uu & uu, uu);
res(end+1) = isequal(uu & ff, ff);
res(end+1) = isequal(uu & ii, ii);
res(end+1) = isequal(ff & tt, ff);
res(end+1) = isequal(ff & uu, ff);
res(end+1) = isequal(ff & ff, ff);
res(end+1) = isequal(ff & ii, ff);
res(end+1) = isequal(ii & tt, ii);
res(end+1) = isequal(ii & uu, ii);
res(end+1) = isequal(ii & ff, ff);
res(end+1) = isequal(ii & ii, ii);

% disjunction
res(end+1) = isequal(tt | tt, tt);
res(end+1) = isequal(tt | uu, tt);
res(end+1) = isequal(tt | ff, tt);
res(end+1) = isequal(tt | ii, tt);
res(end+1) = isequal(uu | tt, tt);
res(end+1) = isequal(uu | uu, uu);
res(end+1) = isequal(uu | ff, uu);
res(end+1) = isequal(uu | ii, ii);
res(end+1) = isequal(ff | tt, tt);
res(end+1) = isequal(ff | uu, uu);
res(end+1) = isequal(ff | ff, ff);
res(end+1) = isequal(ff | ii, ii);
res(end+1) = isequal(ii | tt, tt);
res(end+1) = isequal(ii | uu, ii);
res(end+1) = isequal(ii | ff, ii);
res(end+1) = isequal(ii | ii, ii);

% negation
res(end+1) = isequal(~tt, ff);
res(end+1) = isequal(~uu, uu);
res(end+1) = isequal(~ff, tt);
res(end+1) = isequal(~ii, ii);

% fromBool
res(end+1) = isequal(fourValued.fromBool(true), tt);
res(end+1) = isequal(fourValued.fromBool(false), ff);

% fromKleene
res(end+1) = isequal(fourValued.fromKleene(kleene.True), tt);
res(end+1) = isequal(fourValued.fromKleene(kleene.Unknown), uu);
res(end+1) = isequal(fourValued.fromKleene(kleene.False), ff);

% arrays
arr1 = [tt,ff,uu,ii];
arr2 = [ff,tt,ii,uu];
res(end+1) = isequal(arr1 & arr2, [ff,ff,ii,ii]);
res(end+1) = isequal(arr1 | arr2, [tt,tt,ii,ii]);
res(end+1) = isequal(~arr1, [ff,tt,uu,ii]);

% combine results
res = all(res);

% ------------------------------ END OF CODE ------------------------------
