'''
Config for Sparse convolution based FSD.
For simplicity, we only keep the Sparse Convolution related part. And Other parts are same with 'fsd_config.py'.
'''
voxel_size = (0.2, 0.2, 0.2)
point_cloud_range = [-80, -80, -2, 80, 80, 4]
class_names = ['Car', 'Pedestrian', 'Cyclist']
num_classes = len(class_names)
seg_score_thresh = (0.5, 0.25, 0.25)


instance_point_grouping = dict(

    type='IPG',

    # Pseudo Layer, Placeholder for API consistency
    middle_encoder=dict(
        type='PseudoMiddleEncoderForSpconvFSD',
    ),

    # Use the implementation in MMDetection3D with minor modification (do not convert to dense feature map)
    backbone=dict(
        type='SparseUNet',
        in_channels=64,
        sparse_shape=[32, 800, 800],
        order=('conv', 'norm', 'act'),
        norm_cfg=dict(type='naiveSyncBN1d', eps=1e-3, momentum=0.01),
        base_channels=64,
        output_channels=128,
        encoder_channels=((64, ), (64, 64, 64), (64, 64, 64), (128, 128, 128)),
        encoder_paddings=((1, ), (1, 1, 1), (1, 1, 1), ((0, 1, 1), 1, 1)),
        decoder_channels=((128, 128, 128), (64, 64, 64), (64, 64, 64), (64, 64, 64)),
        decoder_paddings=((1, 0), (1, 0), (0, 0), (0, 1)),
    ),

)