# DPO-Diff: On the Discrete Prompt Optimization for Text-to-Image Diffusion Models

Abstract

<br/><br/>

### Enable OpenAI API access
We use GPT-4 from OpenAI to generate search spaces (offline to avoid duplicated queries). To enable OpenAI access, simply create `dpo-diff/files/openai_key.txt` and place your private key in the file.

<br/><br/>

## Getting Started

0. **Prepare a list of hard prompts:**
```bash 
bash tmux-prepare-prompt.sh --dataset coco --data_dir coco --num_samples 4000 --num_seeds 1 --version v1-4
bash filter-prompt.sh --mode above --thresh 0.85 --prompt_path <data_dir>/usps-loss.json
```

1. **Generate Search Space (Synonyms Space for Attack):**
```bash
bash tmux-space.sh --task attack --model gpt-4 --prompt_path <>
bash tmux-space.sh --task improve --model gpt-4 --prompt_path <>
```

2. **Run Search:**

```bash
bash improve-hybrid.sh --path <path/to/search/space/json>
bash attack-hybrid.sh --path <path/to/search/space/json>
```