#!/bin/bash
#### exp management
script_name=`basename "$0"`
id=${script_name%.*}
entry=${entry:-'src'}
seed=${seed:-2}
gpu=${gpu:-"auto"}
gentle=${gentle:-0}
group=${group:-"default"}
tag=${tag:-"none"}
override=${override:-""}

#### dev
version=${version:-"v1-4"}

#### data
path=${path:-"coco/usps-loss-above=0.85-100-{}-gpt4.json"}
prompt_id=${prompt_id:-0}

#### task
task=${task:-"neg-opp-lib"}
num_seeds=${num_seeds:-3}
num_seeds_train=${num_seeds_train:-3}

#### algo
num_exps=${num_exps:-1}
loss=${loss:-'spherical'}
gumbel_samples=${gumbel_samples:-60}
## ea
population_num=${population_num:-20}
## gpo
num_iters=${num_iters:-20}
best=${best:-3}
t=${t:-'step-15-2'}

## visualization
wandb=${wandb:-0}
save_image=${save_image:-1}


while [ $# -gt 0 ]; do
    if [[ $1 == *"--"* ]]; then
        param="${1/--/}"
        declare $param="$2"
    fi
    shift
done
prompt_id_list=$(echo $prompt_id | tr ',' ' ')


cd ../
run_exp() {
    python ${entry}/run_search.py \
        --group $group --save $id --tag $tag --gpu $gpu --gentle $gentle --wandb $wandb --save_image $save_image \
        --path $path --prompt_id $1 --version $version --task $task --num_exps=$num_exps \
        --num_seeds $num_seeds --num_seeds_train $num_seeds_train \
        --gumbel_samples $gumbel_samples --num_iters $num_iters  --loss $loss --t $t --best $best \
        --population_num $population_num
}

for pid in $prompt_id_list
do
    if [ "$override" != "" ]
    then
        echo "$override" | run_exp $pid
    else
        run_exp $pid
    fi
done
