#!/bin/bash
#### maual attack - filter concepts
script_name=`basename "$0"`
id=${script_name%.*}
entry=${entry:-'src'}
seed=${seed:-2}
gpu=${gpu:-"auto"}
gentle=${gentle:-0}
group=${group:-"ea"}
tag=${tag:-"none"}
override=${override:-""}

#### dev
cls=${cls:-"vit-laion"}
stats=${stats:-"model"}
ipc=${ipc:-10}
version=${version:-"v1-4"}

prompt_id=${prompt_id:-0}

constraint=${constraint:-"bert_score_gpt2"}
thresh=${thresh:-0.0}

num_exps=${num_exps:-1}
max_epochs=${max_epochs:-10}

path=${path:-"substitutes-dev"}
reverse=${reverse:--1}
task=${task:-"attack"}


while [ $# -gt 0 ]; do
    if [[ $1 == *"--"* ]]; then
        param="${1/--/}"
        declare $param="$2"
    fi
    shift
done
prompt_id_list=$(echo $prompt_id | tr ',' ' ')


cd ../
function run_exp {
    python ${entry}/ea_attack.py \
        --max_epochs $max_epochs \
        --constraint $constraint --thresh $thresh \
        --loss "spherical-full" --use_cutout 0 \
        --num_seeds 3 --gumbel_samples 100 --path $path --prompt_id $1 \
        --group $group --save $id --tag $tag --gpu $gpu --gentle $gentle \
        --reverse $reverse --task $task \
        --num_exps $num_exps \
        --wandb 1
}


for pid in $prompt_id_list
do
    if [ "$override" != "" ]
    then
        echo "$override" | run_exp $pid
    else
        run_exp $pid
    fi
done