#!/bin/bash
#### maual attack - filter concepts
script_name=`basename "$0"`
id=${script_name%.*}
entry=${entry:-'src'}
seed=${seed:-2}
gpu=${gpu:-"auto"}
gentle=${gentle:-0}
group=${group:-"sota-bench"}
tag=${tag:-"none"}
override=${override:-""}

#### dev
cls=${cls:-"vit-laion"}
stats=${stats:-"model"}
ipc=${ipc:-1}
version=${version:-"v1-4"}

#### data
path=${path:-"substitutes-dev"}
prompt_id=${prompt_id:-0}

#### algo
## filter
constraint=${constraint:-"bert_score_gpt2"}
thresh=${thresh:-0.0}
gumbel_samples=${gumbel_samples:-100}

initial_coeff=${initial_coeff:-1}
max_coeff=${max_coeff:-2}
num_exps=${num_exps:-4}
num_iters=${num_iters:-60}
batch_size=${batch_size:-1}
num_seeds_train=${num_seeds_train:-3}
clip_grad=${clip_grad:-0.05}
## dev
hard_sample=${hard_sample:-1}
t=${t:-'rand-15-25'}
best=${best:-0}

## improve
reverse=${reverse:--1}
task=${task:-"attack"}

## vis
wandb=${wandb:-1}


while [ $# -gt 0 ]; do
    if [[ $1 == *"--"* ]]; then
        param="${1/--/}"
        declare $param="$2"
    fi
    shift
done
prompt_id_list=$(echo $prompt_id | tr ',' ' ')

cd ../
run_exp() {
    python ${entry}/gbda_attack.py \
        --group $group --save $id --tag $tag --gpu $gpu --gentle $gentle \
        --path $path --prompt_id $1 --constraint $constraint --thresh $thresh \
        --loss "spherical-full" --use_cutout 0 \
        --num_seeds 3 --num_seeds_train $num_seeds_train --gumbel_samples $gumbel_samples \
        --num_iters $num_iters --grad_accum_iters $batch_size \
        --reverse $reverse --task $task \
        --min_coeff 0 --max_coeff $max_coeff --initial_coeff $initial_coeff --clip_grad $clip_grad \
        --hard_sample $hard_sample --t $t --best $best \
        --wandb $wandb --num_exps=$num_exps
}

for pid in $prompt_id_list
do
    if [ "$override" != "" ]
    then
        echo "$override" | run_exp $pid
    else
        run_exp $pid
    fi
done
