#!/bin/bash
#### maual attack - filter concepts
script_name=`basename "$0"`
id=${script_name%.*}
entry=${entry:-'src'}
seed=${seed:-2}
gpu=${gpu:-"auto"}
gentle=${gentle:-0}
tag=${tag:-"none"}
override=${override:-""}

#### dev
cls=${cls:-"vit-laion"}
stats=${stats:-"model"}
ipc=${ipc:-1}
version=${version:-"v1-4"}

#### data
path=${path:-"data/dev/substitutes-dev"}
prompt_id=${prompt_id:-0}

#### algo
## filter
constraint=${constraint:-"bert_score_gpt2"}
thresh=${thresh:-0.0}

num_exps=${num_exps:-4}
batch_size=${batch_size:-1}
clip_grad=${clip_grad:-0.025}
## dev
infer_step=${infer_step:-50}
best_soft=${best_soft:-0}

## improve
reverse=${reverse:--1}
task=${task:-"attack"}

## ea
explore=${explore:-0.0}
explore_inv=${explore_inv:-0}
crossover_num=${crossover_num:-10}
mutation_num=${mutation_num:-10}
m_prob=${m_prob:-0.1}
select_num=${select_num:-10}
## vis

## mods
opt=${opt:-'rmsprop'}
lr=${lr:-0.1}
betas=${betas:-'(0.5,0.999)'}
num_iters=${num_iters:-20}

init_coeff=${init_coeff:-1}
max_coeff=${max_coeff:-3}

best=${best:-3}
best_infer_step=${best_infer_step:-50}
t=${t:-'step-15-2'}
first_argmax=${first_argmax:-1}

group=${group:-"sota-single-seed"}
gumbel_samples=${gumbel_samples:-20}
population_num=$gumbel_samples
wandb=${wandb:-0}
num_seeds=${num_seeds:-1}
num_seeds_train=${num_seeds_train:-1}


while [ $# -gt 0 ]; do
    if [[ $1 == *"--"* ]]; then
        param="${1/--/}"
        declare $param="$2"
    fi
    shift
done
prompt_id_list=$(echo $prompt_id | tr ',' ' ')


cd ../
run_exp() {
    python ${entry}/gbda_attack.py \
        --group $group --save $id --tag $tag --gpu $gpu --gentle $gentle \
        --path $path --prompt_id $1 --constraint $constraint --thresh $thresh \
        --loss "spherical-full" --use_cutout 0 \
        --num_seeds $num_seeds --num_seeds_train $num_seeds_train --gumbel_samples $gumbel_samples \
        --num_iters $num_iters --grad_accum_iters $batch_size \
        --reverse $reverse --task $task \
        --min_coeff 0 --max_coeff $max_coeff --init_coeff $init_coeff --clip_grad $clip_grad \
        --infer_step $infer_step --t $t --first_argmax $first_argmax --opt $opt --betas $betas \
        --best $best --best_soft $best_soft --best_infer_step $best_infer_step \
        --explore $explore --explore_inv $explore_inv --m_prob $m_prob --population_num $population_num --crossover_num $crossover_num --mutation_num $mutation_num --select_num $select_num --m_prob $m_prob \
        --wandb $wandb --num_exps=$num_exps \
        --lr $lr
}

for pid in $prompt_id_list
do
    if [ "$override" != "" ]
    then
        echo "$override" | run_exp $pid
    else
        run_exp $pid
    fi
done
