#!/bin/bash
#### maual attack - filter concepts
script_name=`basename "$0"`
id=${script_name%.*}
entry=${entry:-'src'}
seed=${seed:-2}
gpu=${gpu:-"auto"}
gentle=${gentle:-0}
group=${group:-"ppt"}
tag=${tag:-"none"}
override=${override:-""}

#### dev
cls=${cls:-"vit-laion"}
stats=${stats:-"model"}
ipc=${ipc:-1}
version=${version:-"v1-4"}

#### data
# path=${path:-"data/dev/substitutes-dev"}
path=${path:-"data/diffdb-newpipe/usps-loss-above=0.85-opps.json"}
# path=${path:-"data/chatgpt/subs-chatgpt-poor-above=0.84-opp.json"}
prompt_id=${prompt_id:-0}

#### algo
## filter
constraint=${constraint:-"bert_score_gpt2"}
thresh=${thresh:-0.0}
gumbel_samples=${gumbel_samples:-100}

num_seeds_train=${num_seeds_train:-3}
num_seeds=${num_seeds:-3}
num_exps=${num_exps:-1}

## improve
reverse=${reverse:--1}
task=${task:-"attack"}

## vis
wandb=${wandb:-1}

## ea
population_num=${population_num:-20}
crossover_num=${crossover_num:-10}
mutation_num=${mutation_num:-10}
m_prob=${m_prob:-0.1}
select_num=${select_num:-10}

while [ $# -gt 0 ]; do
    if [[ $1 == *"--"* ]]; then
        param="${1/--/}"
        declare $param="$2"
    fi
    shift
done
prompt_id_list=$(echo $prompt_id | tr ',' ' ')


cd ../
run_exp() {
    python ${entry}/ea_attack.py \
        --group $group --save $id --tag $tag --gpu $gpu --gentle $gentle \
        --path $path --prompt_id $1 --constraint $constraint --thresh $thresh \
        --loss "spherical-full" --use_cutout 0 \
        --num_seeds $num_seeds --num_seeds_train $num_seeds_train --gumbel_samples $gumbel_samples \
        --reverse $reverse --task $task \
        --population_num $population_num --crossover_num $crossover_num --mutation_num $mutation_num --m_prob $m_prob --select_num $select_num \
        --wandb $wandb --save_image 1 --num_exps=$num_exps
}

for pid in $prompt_id_list
do
    if [ "$override" != "" ]
    then
        echo "$override" | run_exp $pid
    else
        run_exp $pid
    fi
done
