#!/bin/bash
script_name=`basename "$0"`
id=${script_name%.*}

## prepare prompts
dataset=${dataset:-'none'}
data_dir=${data_dir:-'none'}
pipe=${pipe:-'gen-eval'}

start_pid=${start_pid:-0}
num_samples=${num_samples:-4000}
num_seeds=${num_seeds:-3}
thresh=${thresh:-0.85}
gpus=${gpus:-'0,1,2,3,4,5,6,7'}

## filter

## build search space
task=${task:-'improve'}
thresh=${thresh:-0.85}
version=${version:-'v1-4'}


while [ $# -gt 0 ]; do
    if [[ $1 == *"--"* ]]; then
        param="${1/--/}"
        declare $param="$2"
    fi
    shift
done


# ## make and eval prompts
# cd ../data
# bash tmux-prepare-prompt.sh --dataset $dataset --data_dir $data_dir --num_samples $num_samples --num_seeds $num_seeds --version $version --start_pid $start_pid --pipe $pipe --gpus $gpus

# ## filter
# cd ../data
# bash filter-prompt.sh --mode above --thresh $thresh --prompt_path $data_dir/usps-loss.json
# bash filter-prompt.sh --mode above --thresh 0.9 --prompt_path $data_dir/usps-loss.json
# bash filter-prompt.sh --mode below --thresh $thresh --prompt_path $data_dir/usps-loss.json
# bash filter-prompt.sh --mode below --thresh 0.8 --prompt_path $data_dir/usps-loss.json
# ## build space
# cd ../scripts
# # improve
# bash build-search-space.sh --task improve --prompt_path $data_dir/usps-loss-above=$thresh-100.json --model gpt-4 --prefix default
# bash build-search-space.sh --task improve --prompt_path $data_dir/usps-loss-above=$thresh-100.json --model gpt-4 --prefix keyword
# attack
# bash build-search-space.sh --task attack --prompt_path $data_dir/usps-loss-below=0.8-100.json --model gpt-4 --prefix default
bash build-search-space.sh --task attack --prompt_path $data_dir/usps-loss-below=0.8-100.json --model gpt-4 --prefix keyword