#!/bin/bash
script_name=`basename "$0"`
id=${script_name%.*}

prompt_path=${prompt_path:-'none'}
model=${model:-'gpt-4'}
prefix=${prefix:-'default'}  ## keyword
task=${task:-'improve'} 

while [ $# -gt 0 ]; do
    if [[ $1 == *"--"* ]]; then
        param="${1/--/}"
        declare $param="$2"
    fi
    shift
done

bash build-search-space.sh --task $task --prompt_path $prompt_path --model $model --prefix $prefix