import random
import math

'''
abl_level in [0,3] is the level of ablation
abl_number in [0,12] is the ablation number
'''


class obs_abl:
    def __init__(self):
        pass

    # andom ablation in each row separately
    def row_random(self, abl_level, abl_number,chosen):
        rest = [i for i in list(range(0 + 12 * abl_level, 12 + 12 * abl_level)) if i not in chosen]
        miss = random.sample(rest,1)
        miss.extend(chosen)
        rest_obs = [i for i in list(range(36)) if i not in miss]
        return miss, rest_obs

    # global random ablation
    def global_random(self, abl_number,chosen):
        rest = [i for i in list(range(36)) if i not in chosen]
        miss = random.sample(rest,1)
        miss.extend(chosen)
        rest_obs = [i for i in list(range(36)) if i not in miss]
        return miss, rest_obs

    # row traversal ablation
    def row_iteration_1st(self, abl_number):
        miss = list(range(abl_number))
        rest_obs = [i for i in list(range(36)) if i not in miss]
        return miss, rest_obs

    # column traversal ablation
    def row_iteration_2nd(self, abl_number):
        miss = list(range(18,abl_number+18))
        rest_obs = [i for i in list(range(36)) if i not in miss]
        return miss, rest_obs

    # check and replace the state if the state is be ablated
    def state_judge(self, state, miss_index, rest_obs):
        all_available_state = list(range(36))
        if state in miss_index:
            state_up = state + 12
            state_down = state - 12
            state_left = state - 1
            state_right = state + 1
            #state_mirror = state + 1
            available_new_state = []
            if state_up in all_available_state and state_up not in miss_index:
                available_new_state.append(state_up)
            if state_down in all_available_state and state_up not in miss_index:
                available_new_state.append(state_down)
            if state_left in all_available_state and state_up not in miss_index:
                available_new_state.append(state_left)
            if state_right in all_available_state and state_up not in miss_index:
                available_new_state.append(state_right)
            #if state_mirror in all_available_state and state_mirror not in miss_index:
            #    available_new_state.append(state_mirror)
            if len(available_new_state) == 0:
                state = rest_obs[len(rest_obs) - 1]
                return state
            else:
                state = available_new_state[0]
                return state
        else:
            return state
