import pandas as pd
import os
import ast

#print(os.path.abspath(os.path.join(os.path.dirname("__file__"),os.path.pardir)))
#os.chdir('C:/Users/English/Desktop/observation_decomposition')



def pre_processing(alg):
    data2=pd.DataFrame(columns=['value', 'type','ablation'])

    for i in range(10):
        print('i:'+str(i))
        data=pd.read_csv('./result/'+alg+'_global_rand_abl_'+str(i)+'.csv')
        data['type']=data['Unnamed: 0']
        data=data.drop(['Unnamed: 0'], axis=1)

        for j in range(len(data.index)):
            temp=pd.DataFrame(columns=['value', 'type','ablation'])
            temp['value']=list(data.iloc[j,:-1])
            temp['type']=[data['type'][j]]*len(list(data.iloc[j,:-1]))
            temp['ablation']=list(data.columns)[:-1]
            if j ==0 and i ==0:
                data2=temp
            else:
                data2=data2.append(temp)
    data2=data2.groupby(['ablation', 'type'])['value'].mean()
    data2.to_csv('./result/preprocessing/'+alg+'_global_rand_abl_all.csv')



def run():
    pre_processing('q_learning')
    pre_processing('sarsa')

if __name__=="__main__":
    run()
