import pandas as pd
import os
import ast

#print(os.path.abspath(os.path.join(os.path.dirname("__file__"),os.path.pardir)))
os.chdir('C:/Users/English/Desktop/observation_decomposition')



def pre_processing(alg):
    data2=pd.DataFrame(columns=['value', 'type','ablation','ablation_level'])

    for i in range(10):
        print('i:'+str(i))
        data=pd.read_csv('./result/'+alg+'_row_abl_'+str(i)+'.csv')
        data['ablation']=data['Unnamed: 0']
        data=data.drop(['Unnamed: 0'], axis=1)

        for j in range(len(data.columns)-1):
            for k in range(len(data[str(j)])):
                temp=pd.DataFrame.from_dict(ast.literal_eval(data[str(j)][k]), orient='index')
                temp.columns=['value']
                temp['type']=list(temp.index)
                temp.index=range(len(temp))
                temp['ablation_level']=[j]*len(temp)
                temp['ablation']=[k]*len(temp)
                if j ==0 and k ==0 and i ==0:
                    data2=temp
                else:
                    data2=data2.append(temp)

    data2 = data2.groupby(['ablation', 'type','ablation_level'])['value'].mean()
    data2.to_csv('./result/preprocessing/'+alg+'_row_abl_all.csv')



def run():
    pre_processing('q_learning')
    pre_processing('sarsa')


if __name__=="__main__":
    run()
