import matplotlib.pyplot as plt
import os
import pandas as pd
from pylab import *
from matplotlib.backends.backend_pdf import PdfPages

#print(os.path.abspath(os.path.join(os.path.dirname("__file__"),os.path.pardir)))
#os.chdir(os.path.abspath(os.path.join(os.path.dirname("__file__"),os.path.pardir)))

def run():
    q_learning=pd.read_csv('./result/preprocessing/q_learning_global_rand_abl_all.csv')
    sarsa=pd.read_csv('./result/preprocessing/sarsa_global_rand_abl_all.csv')

    q_lambda_fil=q_learning[q_learning.type=='lambda']
    q_lambda_fil=q_lambda_fil.sort_values(by='ablation',ascending=True)
    q_rewards_fil=q_learning[q_learning.type=='rewards']
    q_rewards_fil=q_rewards_fil.sort_values(by='ablation',ascending=True)
    q_step_fil=q_learning[q_learning.type=='step']
    q_step_fil=q_step_fil.sort_values(by='ablation',ascending=True)
    q_boolean_weight_lambda_fil=q_learning[q_learning.type=='boolean_weight_lambda']
    q_boolean_weight_lambda_fil=q_boolean_weight_lambda_fil.sort_values(by='ablation',ascending=True)

    s_lambda_fil=sarsa[sarsa.type=='lambda']
    s_lambda_fil=s_lambda_fil.sort_values(by='ablation',ascending=True)
    s_rewards_fil=sarsa[sarsa.type=='rewards']
    s_rewards_fil=s_rewards_fil.sort_values(by='ablation',ascending=True)
    s_step_fil=sarsa[sarsa.type=='step']
    s_step_fil=s_step_fil.sort_values(by='ablation',ascending=True)
    s_boolean_weight_lambda_fil=sarsa[sarsa.type=='boolean_weight_lambda']
    s_boolean_weight_lambda_fil=s_boolean_weight_lambda_fil.sort_values(by='ablation',ascending=True)


    fig, ax = plt.subplots()


    x_major_locator=MultipleLocator(2)
    ax.xaxis.set_major_locator(x_major_locator)

    plt.figure(1)
    plt.plot(q_lambda_fil.ablation,q_lambda_fil.value,'o-',color = 'r',label="Q LEARNING CL")#s-:方形
    #plt.plot(q_rewards_fil.ablation,q_rewards_fil.value,'o-',color = 'g',label="Q LEARNING REWARD")#o-:圆形
    plt.plot(s_boolean_weight_lambda_fil.ablation, s_boolean_weight_lambda_fil.value, '*-', color='b', label="Q LEARNING BL")  # o-:圆形
    #plt.plot(q_step_fil.ablation,q_step_fil.value,'o-',color = 'b',label="Q LEARNING STEP")#o-:圆形

    plt.plot(s_lambda_fil.ablation,s_lambda_fil.value,'s-',color = 'r',label="SARSA CL")#s-:方形
    #plt.plot(s_rewards_fil.ablation,s_rewards_fil.value,'s-',color = 'g',label="SARSA REWARD")#o-:圆形
    plt.plot(s_boolean_weight_lambda_fil.ablation, s_boolean_weight_lambda_fil.value, '*-', color='b', label="Q LEARNING BL")  # o-:圆形
    #plt.plot(s_step_fil.ablation,s_step_fil.value,'s-',color = 'b',label="SARSA STEP")#o-:圆形

    plt.xlabel("number of dimension ablations")#横坐标名字
    plt.ylabel("value")#纵坐标名字


    lgnd = plt.legend(bbox_to_anchor=(0.995, 1), loc=2,fontsize=7)
    fig.subplots_adjust(right=0.77)

    plt.savefig('./visualization/global.svg',format="svg")
    plt.savefig('./visualization/global.png', format="png")
    plt.savefig('./visualization/global.pdf', format="pdf")
    plt.show()

if __name__=="__main__":
    run()


