import matplotlib.pyplot as plt
import os
import pandas as pd
from pylab import *

# print(os.path.abspath(os.path.join(os.path.dirname("__file__"),os.path.pardir)))
#os.chdir(os.path.abspath(os.path.join(os.path.dirname("__file__"),os.path.pardir)))

def run():
    q_learning=pd.read_csv('./result/preprocessing/q_learning_row_abl_all.csv')
    sarsa=pd.read_csv('./result/preprocessing/sarsa_row_abl_all.csv')
    plt.figure(figsize=(16, 11))
    for i in range(3):
        plt.subplot(3, 1, i+1)
        q_lambda_fil=q_learning[(q_learning.type=='lambda') & (q_learning.ablation_level==i)]
        q_lambda_fil=q_lambda_fil.sort_values(by='ablation',ascending=True)
        q_boolean_weight_lambda_fil = q_learning[(q_learning.type == 'boolean_weight_lambda') & (q_learning.ablation_level==i)]
        q_boolean_weight_lambda_fil = q_boolean_weight_lambda_fil.sort_values(by='ablation', ascending=True)

        s_lambda_fil=sarsa[(sarsa.type=='lambda') & (sarsa.ablation_level==i)]
        s_lambda_fil=s_lambda_fil.sort_values(by='ablation',ascending=True)
        s_boolean_weight_lambda_fil = sarsa[(sarsa.type == 'boolean_weight_lambda') & (sarsa.ablation_level==i)]
        s_boolean_weight_lambda_fil = s_boolean_weight_lambda_fil.sort_values(by='ablation', ascending=True)

        fig, ax = plt.subplots()

        x_major_locator=MultipleLocator(2)
        ax.xaxis.set_major_locator(x_major_locator)

        size = len(s_boolean_weight_lambda_fil)

        x = np.arange(size)
        a = q_lambda_fil.value
        b = s_lambda_fil.value
        c = q_boolean_weight_lambda_fil.value
        d = s_boolean_weight_lambda_fil.value

        total_width, n = 0.8, 4
        width = total_width / n
        x = x - (total_width - width) / 2

        plt.figure(1)
        plt.bar(x, a, width=width, label='Q LEARNING CL')
        plt.bar(x + width, b, width=width, label='SARSA CL')
        plt.bar(x + 2 * width, c, width=width, label='Q LEARNING BL')
        plt.bar(x + 3 * width, d, width=width, label='SARSA BL')

        # plt.plot(q_lambda_fil.ablation,q_lambda_fil.value,'o-',color = 'r',label="Q LEARNING LAMBDA")
        # plt.plot(s_lambda_fil.ablation,s_lambda_fil.value,'s-',color = 'g',label="SARSA LAMBDA")
        # plt.plot(q_lambda_fil.ablation,q_lambda_fil.value,'o-',color = 'r',label="Q LEARNING LAMBDA")
        # plt.plot(s_lambda_fil.ablation,s_lambda_fil.value,'s-',color = 'g',label="SARSA LAMBDA")


        plt.xlabel("number of dimension ablations",fontsize=15)
        plt.ylabel("value",fontsize=15)

        plt.legend(bbox_to_anchor=(0.995, 1), loc=2,fontsize=9)
        fig.subplots_adjust(right=0.77)


    # plot lambda only
    #plt.figure(figsize=(16, 11))
    '''
    for i in range(3):
        plt.subplot(3, 1, i+1)
        q_lambda_fil=q_learning[(q_learning.type=='lambda') & (q_learning.ablation_level==i)]
        q_lambda_fil=q_lambda_fil.sort_values(by='ablation',ascending=True)
        q_boolean_weight_lambda_fil = q_learning[q_learning.type == 'boolean_weight_lambda']
        q_boolean_weight_lambda_fil = q_boolean_weight_lambda_fil.sort_values(by='ablation', ascending=True)

        s_lambda_fil=sarsa[(sarsa.type=='lambda') & (q_learning.ablation_level==i)]
        s_lambda_fil=s_lambda_fil.sort_values(by='ablation',ascending=True)
        s_boolean_weight_lambda_fil = sarsa[sarsa.type == 'boolean_weight_lambda']
        s_boolean_weight_lambda_fil = s_boolean_weight_lambda_fil.sort_values(by='ablation', ascending=True)

        fig, ax = plt.subplots()

        x_major_locator=MultipleLocator(2)
        ax.xaxis.set_major_locator(x_major_locator)

        plt.figure(1)
        plt.plot(q_lambda_fil.ablation,q_lambda_fil.value,'o-',color = 'r',label="Q LEARNING LAMBDA")
        plt.plot(s_lambda_fil.ablation,s_lambda_fil.value,'s-',color = 'g',label="SARSA LAMBDA")
        plt.plot(q_lambda_fil.ablation,q_lambda_fil.value,'o-',color = 'r',label="Q LEARNING LAMBDA")
        plt.plot(s_lambda_fil.ablation,s_lambda_fil.value,'s-',color = 'g',label="SARSA LAMBDA")


        plt.xlabel("number of dimension ablations",fontsize=15)
        plt.ylabel("value",fontsize=15)

        plt.legend(bbox_to_anchor=(0.995, 1), loc=2,fontsize=9)
        fig.subplots_adjust(right=0.77)
    '''
    plt.savefig('./visualization/row_abl2.svg',format="svg", pad_inches=0.0,bbox_inches='tight')
    plt.savefig('./visualization/row_abl2.png', format="png", pad_inches=0.0, bbox_inches='tight')
    plt.savefig('./visualization/row_abl2.pdf', format="pdf", pad_inches=0.0, bbox_inches='tight')
    plt.show()

if __name__=="__main__":
    run()

