"""Utility functions.
"""
import math
import numpy as np


def tally_parameters(model):
  n_params = sum([p.nelement() for p in model.parameters()])
  print('* number of parameters: %d' % n_params)


def inverse_softplus(y):
  return math.log(math.exp(y) - 1)


def logit(y):
  return np.log(y / (1 - y)).astype('float32')


def print_opts(opts):
  """Prints the values of all command-line arguments.
  """
  print('=' * 80)
  print('Opts'.center(80))
  print('-' * 80)
  for key in opts.__dict__:
    value = opts.__dict__[key]
    if value is None:
      print('{:>30}: {:<30}'.format(key, 'None').center(80))
    else:
      print('{:>30}: {:<30}'.format(key, value).center(80))
  print('=' * 80)
