import sys
import zconf


@zconf.run_config
class RunConfiguration(zconf.RunConfig):
    method = zconf.attr(required=True)
    dataset = zconf.attr(required=True)


def main(args):
    import examples.attribution_benchmark as attribution_benchmark
    experiment = attribution_benchmark.Experiment(
        series='attribution_benchmarks',
        method=args.method,
        arch='resnet50',
        dataset=args.dataset,
        chunk=None,
        root="/anon_path/series",
    )
    attribution_benchmark.ExperimentExecutor(experiment, log=0).run()


if __name__ == '__main__':
    main(RunConfiguration.run_cli())
