# Multi-Task Vehicle Routing Solver via Mixture of Specialized Experts under State-Decomposable MDP

## Introduction
This is the official PyTorch implementation for the paper titled ["Multi-Task Vehicle Routing Solver via Mixture of Specialized Experts under State-Decomposable MDP"]().
In this paper, we introduce a State-Decomposable MDP (SDMDP) that reformulates VRPs to yield the optimal basis policy for each basis VRP variant. 
Furthermore, a Latent Space-based SDMDP extension is developed by incorporating both the optimal basis policies and a learnable mixture function to enable the policy reuse in the latent space. 
This extension provably recovers the optimal unified policy of SDMDP through the mixture function that computes the state embedding as a mapping from the basis state embeddings generated by optimal basis policies. 
For practical implementation, we introduce the Mixture-of-Specialized-Experts Solver (MoSES) as the unified multi-task VRP solver, which realizes basis policies through specialized Low-Rank Adaptation (LoRA) experts, 
and implements the mixture function via an adaptive gating mechanism. Extensive experiments conducted across 16 VRP variants showcase the superiority of MoSES over prior methods.


In the MoSES framework, the training process involves three stages: 
(1) pretraining a shared backbone model for CVRP;
(2) fine-tuning specialized LoRA experts based on frozen backbone model for OVRP, VRPL, VRPB and VRPTW, respectively; 
(3) dynamically aggregating LoRA experts as MoSES for 16 VRP variants.
The MoSES framework is implemented based on the [RouteFinder model](https://arxiv.org/pdf/2406.15007) and [CaDA model](https://arxiv.org/pdf/2412.00346).
This repository is developed upon the [RouteFinder Repository](https://github.com/ai4co/routefinder) and [CaDA Repository](https://github.com/panyxy/cada_code).

## Dependencies

Before executing the training process, please ensure that the necessary requirements have been installed.
```
conda create -n moses_env python=3.10
conda activate moses_env
pip install torch==2.6.0 --index-url https://download.pytorch.org/whl/cu118
pip install -r requirements.txt
```

## Training Monitor
Please enter your personal wandb login key in the ***run.py*** file, and configure the W&B settings in the configuration files under ***configs/experiment***.


## Generate Datasets
Please adhere to the guidelines outlined in the ["RouteFinder"](https://github.com/ai4co/routefinder) repository to create datasets, and then transfer the "data" directory from RouteFinder to this project.


## Training
**(1) pretraining a shared backbone model for CVRP**
```
# MoSES(RF):
bash scripts/train_rf_base.sh [number of nodes: 50, 100]

# MoSES(CaDA):
bash scripts/train_cada_base.sh [number of nodes: 50, 100]
```

**(2) fine-tuning specialized LoRA experts based on frozen backbone model for OVRP, VRPL, VRPB and VRPTW, respectively**

Please set the value of the option ***basis_policy_ckpt_path*** in the corresponding configuration files to the path of the pretrained model.
```
# MoSES(RF):
bash scripts/train_rf_lora.sh [number of nodes: 50, 100] 32 false

# MoSES(CaDA):
bash scripts/train_cada_lora.sh [number of nodes: 50, 100] 32 false
```

**(3) dynamically aggregating LoRA experts as MoSES for 16 VRP variants**

Please set the value of the option ***lora_modules_ckpt_path*** in the corresponding configuration files to the list of paths for the LoRA experts.
```
# MoSES(RF):
bash scripts/train_rf_multilora.sh [number of nodes: 50, 100] true false false [32,32,32,32,32] false false

# MoSES(CaDA):
bash scripts/train_cada_multilora.sh [number of nodes: 50, 100] true false false [32,32,32,32,32] false false
```

## Evaluation
We have provided the pretrained model for you to use directly.

```
# MoSES(RF) and MoSES(CaDA) on generated dataset:
bash scripts/test_script.sh

# MoSES(RF) and MoSES(CaDA) on CVRPLIB dataset:
bash scripts/test_vrplib_script.sh
```



## Acknowledgement
We appreciate the anonymous reviewers, (S)ACs, and PCs of NeurIPS 2025 for their insightful
comments to further improve our paper and their service to the community.
We would like to thank the authors of RouteFinder for providing their highly valuable [implementation of RouteFinder](https://github.com/ai4co/routefinder).


## Citation

```
@inproceedings{pan2025moses,
 author = {Pan, Yuxin and Cao, Zhiguang and Gu, Chengyang, and Liu, Liu, and Zhao, Peilin and Chen, Yize and Lin, Fangzhen},
 booktitle = {Advances in Neural Information Processing Systems},
 title = {Multi-Task Vehicle Routing Solver via Mixture of Specialized Experts under State-Decomposable MDP},
 year = {2025},
 url={https://openreview.net/forum?id=ezSyZM6Lp7}
}
```

## License
This source code is provided solely for academic use. 
Please refrain from using it for commercial purposes without obtaining proper authorization from the author.

