Supplementary Material for Faster Training of Neural ODEs using Gauss-Legendre Quadrature.

In this zip file we include the appendices, the code.



# Requirements:
The code requires Python 3.8, PyTorch, as well as standard libraries such as NumPy. 


# Usage:

**Important:** When writing ODE functions using the GQ method, one must include the number of function evaluations
for it to work.

This code contains a Neural Differential equation class as well as a trainer class to allow for faster
development. These are provided in models/neural_de.py and models/trainer.py. If using these the user must note that:

* x must be shape [ [ [x0(t0)], [x1(t0)] ], [ [x0(t1)], [x1(t1)] ] ], which is t, batch, x
* When making data set, need each vector of times to have been unsqueezed, so have [ [t1], [t2], [t3],...,[tn] ]
* Each initial condition needs its own vector of times, otherwise torch.gather will not give desired results
* The ODE functions work with vectors only, if using convolutions one must first unflatten the vector then flatten at the end
* To create an ODE define a drift only, not a diffusion. To use a certain method for obtaining gradients, include in the initialising arguments:
  * adjoint_option='direct'
  * adjoint_option='adjoint_ode'
  * adjoint_option='adjoint_seminorm'
  * adjoint_option='adjoint_gq'
* To make an SDE define a diffusion and drift, to use Wong Zakai use one of the above options, to make a true sde use
  * adjoint_option='sde_direct'
  * adjoint_option='sde_adjoint'

The gq method can be simply dropped into existing code, if one replaces 'torchdiffeq.odeint' in their code with 'torchdiffeq_gq.odeint_adjoint_gq'


# Running Experiments

Experiments are run from the command line. Bash scripts are written, for example one can run:

```
bash bash_scripts/run_g1d.sh
```

Alternatively one can run experiments individually:

```
python -m experiments.g1d --nepochs 50 --adjoint_option adjoint_gq
```
