#!/bin/bash

NEXPERIMENTS=10
DEVICE=0
SAVE_WIDTH=20

# arguments are number of runs, width, learning rate, device, adjoint_option
run_single() {
COUNTER=1
SAVE=0
while [ $COUNTER -le $1 ]
do
# save the model if required
if [ $COUNTER -eq $1 ] && [ $5 = adjoint_gq ] && [ $2 -eq $SAVE_WIDTH ]
then
SAVE=1
else
SAVE=0
fi
python -m experiments.nested_spheres --width $2 --lr $3 --device $4 --adjoint_option $5 --experiment_no $COUNTER --save_model $SAVE
((COUNTER++))
done
}

# arguments are number of runs, width, learning rate, device
collect_data() {
run_single $1 $2 $3 $4 adjoint_gq
run_single $1 $2 $3 $4 adjoint_ode
run_single $1 $2 $3 $4 adjoint_seminorm
run_single $1 $2 $3 $4 direct
}

# run through all loops and collect the data
collect_data $NEXPERIMENTS 5 0.005 $DEVICE
collect_data $NEXPERIMENTS 20 0.005 $DEVICE
collect_data $NEXPERIMENTS 100 0.001 $DEVICE
collect_data $NEXPERIMENTS 500 0.001 $DEVICE
collect_data $NEXPERIMENTS 1000 0.0002 $DEVICE
collect_data $NEXPERIMENTS 1500 0.0002 $DEVICE
collect_data $NEXPERIMENTS 2000 0.0001 $DEVICE
collect_data $NEXPERIMENTS 2500 0.0001 $DEVICE
collect_data $NEXPERIMENTS 3000 0.0001 $DEVICE























