#!/bin/bash

NEXPERIMENTS=5
DEVICE=0
SAVE_WIDTH=20
NTIMES=50

# arguments are number of runs, width, learning rate, device, adjoint_option
run_single() {
COUNTER=1
SAVE=0
while [ $COUNTER -le $1 ]
do
# save the model if required
if [ $COUNTER -eq $1 ] && [ $5 = adjoint_gq ] && [ $2 -eq $SAVE_WIDTH ]
then
SAVE=1
else
SAVE=0
fi
python -m experiments.sines --width $2 --lr $3 --device $4 --adjoint_option $5 --experiment_no $COUNTER --save_model $SAVE --ntimes $NTIMES
((COUNTER++))
done
}

# arguments are number of runs, width, learning rate, device
collect_data() {
run_single $1 $2 $3 $4 adjoint_gq
run_single $1 $2 $3 $4 adjoint_ode
run_single $1 $2 $3 $4 adjoint_seminorm
run_single $1 $2 $3 $4 direct
}

# run through all loops and collect the data
collect_data $NEXPERIMENTS 5 0.02 $DEVICE
collect_data $NEXPERIMENTS 20 0.008 $DEVICE
collect_data $NEXPERIMENTS 200 0.0005 $DEVICE
collect_data $NEXPERIMENTS 1000 0.00003 $DEVICE
collect_data $NEXPERIMENTS 2000 0.00001 $DEVICE
























