#!/bin/bash

NEXPERIMENTS=3
DEVICE=1
SAVE_WIDTH=50
DATASET=svhn		#remember to set the dataset
BATCHSIZE=16

# arguments are number of runs, width, learning rate, device, adjoint_option
run_single() {
COUNTER=1
SAVE=0
while [ $COUNTER -le $1 ]
do
# save the model if required
if [ $COUNTER -eq $1 ] && [ $5 = adjoint_gq ] && [ $2 -eq $SAVE_WIDTH ]
then
SAVE=1
else
SAVE=0
fi
python -m experiments.images --dataset $DATASET --width $2 --lr $3 --device $4 --adjoint_option $5 --experiment_no $COUNTER --save_model $SAVE --batchsize $BATCHSIZE
((COUNTER++))
done
}

# arguments are number of runs, width, learning rate, device
collect_data() {
run_single $1 $2 $3 $4 adjoint_gq
run_single $1 $2 $3 $4 adjoint_ode
run_single $1 $2 $3 $4 adjoint_seminorm
}

# run through all loops and collect the data
collect_data $NEXPERIMENTS 50 0.00006 $DEVICE
collect_data $NEXPERIMENTS 200 0.00006 $DEVICE
collect_data $NEXPERIMENTS 350 0.00006 $DEVICE
collect_data $NEXPERIMENTS 500 0.00006 $DEVICE



























