"""
calculate the number of terms for the quadrature calculation, finds n based on
the NFE. time and user tolerance, formula found empirically. Uses a formula for the
error. Has a maximum of 64 terms, would work on a degree 127 polynomial
which should be large enough for most applications.
"""

import torch
import numpy as np

nmax = 64
L = 0.0003

def calc_nterms(t0, t1, NFE, gtol):
    n = torch.ceil(L*NFE*(t1-t0)/gtol).item()
    return int(min(n, nmax))
    
