import numpy as np
import pickle
from algorithms import *

M = 100  # total number of clients
n = 10  # total number of samples per client
d = 30  # dimension size of parameter

nu_list = [1.0, 3.0, 10.0] # parameter controlling the level of heterogeneity
result_path = "data/"  # the path to save results

simulated_data = []

for nu in nu_list:
    print("nu={}".format(nu))
    np.random.seed(111)
    w_true = np.exp(np.random.normal(loc=0.0, scale=nu, size=d))  # true parameter to generate data

    # Generate data
    data_list = []
    for m in range(M):
        X = np.zeros((n,d))
        supp = np.random.choice(d)
        X[:, supp] = np.random.normal(loc=1.0, scale=0.1, size=n)
        y = np.matmul(X, w_true) + np.random.normal(loc=0.0, scale=0.1, size=n)
        data_list.append((X, y))

    simulated_data.append(data_list)

# Save results
with open(result_path + "simulated_data_fixed.txt", "wb") as f:
    pickle.dump(simulated_data, f)