import matplotlib.pyplot as plt

# 데이터 정의
alphas = [0, 0.3, 0.5, 0.7, 1, 1.5]
rewards = [-1.413077311, -0.9858, -1.0309, -1.0401, -1.05, -1.0468]

# 그래프 그리기
plt.figure(figsize=(8, 5))
plt.plot(alphas, rewards, marker='o', linestyle='-', linewidth=2)
#plt.title("Effect of Alpha on TPKD Performance", fontsize=14)
plt.xlabel(r"$\alpha$", fontsize=12)
plt.ylabel("Reward Model", fontsize=12)
#plt.grid(True)
plt.tight_layout()
plt.savefig("ablation_alpha_vis.png", dpi=300)
#plt.show()