# dpoteacher-train-student
CUDA_VISIBLE_DEVICES=0,1,2,3 python -m accelerate.commands.launch \
    --num_processes=2 \
    --main_process_port 29501 \
    utils/precompute_logits_for_train.py \
    --data data/llama3.2-1b-deita-dpomix/student_1epoch_adpa_dataset_original \
    --split train \
    --model data/llama3.2-1b-deita-dpomix/dpo_teacher \
    --conversation-key rejected \
    --user-begin "<|begin_of_text|><|start_header_id|>user<|end_header_id|>\n\n" \
    --user-end "<|eot_id|>" \
    --assistant-begin "<|start_header_id|>assistant<|end_header_id|>\n\n" \
    --assistant-end "<|eot_id|>" \
    --save-to data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-dpoteacher-train-student \
    --pad-token-id 128001 \
    --max-tokens-per-batch 2048
rm data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-dpoteacher-train-student/results_rank_*.jsonl


python utils/merge_logits_adpa_dataset.py \
    --input-dataset-dict argilla/dpo-mix-7k \
    --dpo-teacher-logp-train data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-dpoteacher-train-student \
    --ref-teacher-logp-train data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-refteacher-train-student \
    --dpo-teacher-logp-test  data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-dpoteacher-test-student \
    --ref-teacher-logp-test  data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-refteacher-test-student \
    --save-to ~/ADPA/data/llama3.2-1b-deita-dpomix/adpa_1epoch_dataset \
    --logits-key rejected_compressed_probs \
    --label-key rejected_labels \
    --output-key rejected_margin_logp_every

python utils/merge_logits_dckd_dataset.py \
    --input-dataset-dict          argilla/dpo-mix-7k \
    --teacher-chosen-logp-train   data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-dpoteacher-chosen-logp-train \
    --teacher-rejected-logp-train data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-dpoteacher-rejected-logp-train \
    --teacher-chosen-logp-test    data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-dpoteacher-chosen-logp-test \
    --teacher-rejected-logp-test  data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-dpoteacher-rejected-logp-test \
    --save-to                     data/llama3.2-1b-deita-dpomix/dpomix7k-1epoch-dckd


CUDA_VISIBLE_DEVICES=0,1,2,3 \
ACCELERATE_LOG_LEVEL=info \
DS_SKIP_CUDA_CHECK=1 \
python -m accelerate.commands.launch \
  --config_file recipes/accelerate_config/deepspeed_zero3.yaml \
  scripts/run_distill_dpo.py \
  recipes/llama3.2-1b-deita-dpomix/student_adpa.yaml

CUDA_VISIBLE_DEVICES=0,1,2,3 \
ACCELERATE_LOG_LEVEL=info \
DS_SKIP_CUDA_CHECK=1 \
python -m accelerate.commands.launch \
  --config_file recipes/accelerate_config/deepspeed_zero3.yaml \
  scripts/run_distill_dpo.py \
  recipes/llama3.2-1b-deita-dpomix/student_adpap.yaml


