#!/bin/bash

set -e  # 에러 발생 시 스크립트 중단
set -o pipefail  # 파이프라인 내 에러도 감지
trap 'echo -e "\n❌ [ERROR] Command failed: $BASH_COMMAND\n"' ERR

# 로그 디렉토리 설정
LOG_DIR="logs"
mkdir -p "$LOG_DIR"

# 실행 & 로깅 함수
log_and_run () {
  local NAME="$1"
  shift
  local LOG_FILE="$LOG_DIR/${NAME}.log"

  echo -e "\n🔹 [START] $NAME"
  echo "🔸 Logging to: $LOG_FILE"
  echo "------------------------------------------------"

  {
    echo ">>> [Start: $(date)]"
    echo ">>> [Command] $@"
    echo "------------------------------------------------"
    eval "$@"   # <-- 여기!
    echo ">>> [Success: $(date)]"
  } 2>&1 | tee "$LOG_FILE"

  echo -e "✅ [DONE] $NAME\n"
}
log_and_run "precompute_train_chosen" \
"CUDA_VISIBLE_DEVICES=0,1,2,3 python -m accelerate.commands.launch \
  --num_processes=4 \
  --main_process_port 29501 \
  utils/precompute_logits.py \
  --data gx-ai-architect/HelpSteer2_DPO \
  --split train \
  --model meta-llama/Llama-3.1-8B-Instruct \
  --conversation-key chosen \
  --user-begin '<|begin_of_text|><|start_header_id|>user<|end_header_id|>\n\n' \
  --user-end '<|eot_id|>' \
  --assistant-begin '<|start_header_id|>assistant<|end_header_id|>\n\n' \
  --assistant-end '<|eot_id|>' \
  --save-to ./data/helpsteer2/dpomix7k-dpoteacher-chosen-logp-train \
  --pad-token-id 128001 \
  --max-tokens-per-batch 2048"
log_and_run "rm_train_chosen_temp" \
"rm ./data/helpsteer2/dpomix7k-dpoteacher-chosen-logp-train/results_rank_*.jsonl"


# Repeat similarly for:
#   - "chosen" / "rejected" + train/test
# train-rejected
log_and_run "precompute_train_rejected" \
"CUDA_VISIBLE_DEVICES=0,1,2,3 python -m accelerate.commands.launch \
  --num_processes=4 \
  --main_process_port 29501 \
  utils/precompute_logits.py \
  --data gx-ai-architect/HelpSteer2_DPO \
  --split train \
  --model meta-llama/Llama-3.1-8B-Instruct \
  --conversation-key rejected \
  --user-begin '<|begin_of_text|><|start_header_id|>user<|end_header_id|>\n\n' \
  --user-end '<|eot_id|>' \
  --assistant-begin '<|start_header_id|>assistant<|end_header_id|>\n\n' \
  --assistant-end '<|eot_id|>' \
  --save-to ./data/helpsteer2/dpomix7k-dpoteacher-rejected-logp-train \
  --pad-token-id 128001 \
  --max-tokens-per-batch 2048"

log_and_run "rm_train_rejected_temp" \
"rm ./data/helpsteer2/dpomix7k-dpoteacher-rejected-logp-train/results_rank_*.jsonl"

# test-chosen
log_and_run "precompute_test_chosen" \
"CUDA_VISIBLE_DEVICES=0,1,2,3 python -m accelerate.commands.launch \
  --num_processes=4 \
  --main_process_port 29501 \
  utils/precompute_logits.py \
  --data gx-ai-architect/HelpSteer2_DPO \
  --split test \
  --model meta-llama/Llama-3.1-8B-Instruct \
  --conversation-key chosen \
  --user-begin '<|begin_of_text|><|start_header_id|>user<|end_header_id|>\n\n' \
  --user-end '<|eot_id|>' \
  --assistant-begin '<|start_header_id|>assistant<|end_header_id|>\n\n' \
  --assistant-end '<|eot_id|>' \
  --save-to ./data/helpsteer2/dpomix7k-dpoteacher-chosen-logp-test \
  --pad-token-id 128001 \
  --max-tokens-per-batch 2048"

log_and_run "rm_test_chosen_temp" \
"rm ./data/helpsteer2/dpomix7k-dpoteacher-chosen-logp-test/results_rank_*.jsonl"

# test-rejected
log_and_run "precompute_test_rejected" \
"CUDA_VISIBLE_DEVICES=0,1,2,3 python -m accelerate.commands.launch \
  --num_processes=4 \
  --main_process_port 29501 \
  utils/precompute_logits.py \
  --data gx-ai-architect/HelpSteer2_DPO \
  --split test \
  --model meta-llama/Llama-3.1-8B-Instruct \
  --conversation-key rejected \
  --user-begin '<|begin_of_text|><|start_header_id|>user<|end_header_id|>\n\n' \
  --user-end '<|eot_id|>' \
  --assistant-begin '<|start_header_id|>assistant<|end_header_id|>\n\n' \
  --assistant-end '<|eot_id|>' \
  --save-to ./data/helpsteer2/dpomix7k-dpoteacher-rejected-logp-test \
  --pad-token-id 128001 \
  --max-tokens-per-batch 2048"

log_and_run "rm_test_rejected_temp" \
"rm ./data/helpsteer2/dpomix7k-dpoteacher-rejected-logp-test/results_rank_*.jsonl"

log_and_run "merge" \
"python utils/merge_logits_dckd_dataset.py \
    --input-dataset-dict          gx-ai-architect/HelpSteer2_DPO \
    --teacher-chosen-logp-train   ./data/helpsteer2/dpomix7k-dpoteacher-chosen-logp-train \
    --teacher-rejected-logp-train ./data/helpsteer2/dpomix7k-dpoteacher-rejected-logp-train \
    --teacher-chosen-logp-test    ./data/helpsteer2/dpomix7k-dpoteacher-chosen-logp-test \
    --teacher-rejected-logp-test  ./data/helpsteer2/dpomix7k-dpoteacher-rejected-logp-test \
    --save-to                     ./data/helpsteer2/dpomix7k-dckd_nosft"