import os
import argparse
from pathlib import Path
from playwright.sync_api import sync_playwright

def convert_all_html_to_png(input_dir):
    html_files = sorted(Path(input_dir).glob("token_vis_*.html"))

    with sync_playwright() as p:
        browser = p.chromium.launch()
        page = browser.new_page()

        for html_file in html_files:
            png_path = html_file.with_suffix(".png")
            try:
                page.goto(f"file://{html_file.resolve()}")
                page.screenshot(path=str(png_path), full_page=True)
                print(f"✅ {html_file.name} → {png_path.name}")
            except Exception as e:
                print(f"❌ Failed to render {html_file.name}: {e}")

        browser.close()

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Convert HTML token visualizations to PNG.")
    parser.add_argument("--input_dir", type=str, required=True, help="Directory containing HTML files")
    args = parser.parse_args()

    convert_all_html_to_png(args.input_dir)