## Software Requirements

Much code reused from "[deep_Mahalanobis_detector](https://github.com/pokaxpoka/deep_Mahalanobis_detector)" and [odin-pytorch](https://github.com/facebookresearch/odin).

* [Pytorch](http://pytorch.org/)
* [TorchVision](https://github.com/pytorch/vision)
* [TorchNet](https://github.com/pytorch/tnt)
* [Numpy](https://www.numpy.org/)
* [Pandas](https://pandas.pydata.org/)
* [TQDM](https://github.com/tqdm/tqdm)
* [Scikit-Learn](https://scikit-learn.org/stable/)
* [Scipy.org](scipy.org)
* [Matplotlib](https://matplotlib.org/)
* [Seaborn](https://seaborn.pydata.org/)

## Downloading and Generating Out-of-Distribtion Datasets

We use download links of two out-of-distribution datasets from [odin-pytorch](https://github.com/facebookresearch/odin):

* [Tiny-ImageNet (resize)](https://www.dropbox.com/s/kp3my3412u5k9rl/Imagenet_resize.tar.gz)
* [LSUN (resize)](https://www.dropbox.com/s/moqh2wh8696c3yl/LSUN_resize.tar.gz)

Please, place the above compressed files to `data/` and run the following commands in the mentioned directory:

```
tar xvf Imagenet_resize.tar.gz
tar xvf LSUN_resize.tar.gz
```

## Reproducing Experiments

### Train the models and then evaluate the ODD performance:

```
./run_cifar10.sh
./run_cifar100.sh
./run_svhn.sh
```

## Analizing Results

### Print the experiment results:

```
./analize.sh odd
```
