
import argparse
import os
import torch
import math
import sys
import torch.nn.functional as F
import torch.nn as nn
import torchvision
import torchvision.transforms as transforms
import time
import statistics
import numpy as np
import pandas as pd
import seaborn as sns
from sklearn.manifold import TSNE
import matplotlib.pyplot as plt
import random
import time
import matplotlib.patheffects as PathEffects
import pickle
import statistics
from scipy.interpolate import interp1d 

#######################
sns.set_style('darkgrid')
sns.set_palette('muted')
sns.set_context("paper")
#######################


pd.options.display.float_format = '{:,.4f}'.format
pd.set_option('display.width', 160)

parser = argparse.ArgumentParser(description='Analize results in csv files')

parser.add_argument('-p', '--path', default="", type=str, help='Path for the experiments to be analized')
parser.set_defaults(argument=True)

random.seed(1234)
np.random.seed(1234)
torch.manual_seed(1234)
torch.cuda.manual_seed(1234)


def main():

    DATASETS = ['svhn', 'cifar10', 'cifar100']
    EXTRA_DATASETS = [
        'svhn_250', 'svhn_500', 'svhn_1000', 'svhn_2000', 'svhn_3000', 'svhn_4000', 'svhn_5000',
        'cifar10_250', 'cifar10_500', 'cifar10_1000', 'cifar10_2000', 'cifar10_3000', 'cifar10_4000', 'cifar10_5000', 
        'cifar100_25', 'cifar100_50', 'cifar100_100', 'cifar100_200', 'cifar100_300', 'cifar100_400', 'cifar100_500',
        ]

    MODELS = ['densenetbc100', 'resnet110'] 


    print(DATASETS)
    print(MODELS)

    args = parser.parse_args()
    path = os.path.join("expers", args.path)
    if not os.path.exists(path):
        sys.exit('You should pass a valid path to analyze!!!')


    print("\n#####################################")
    print("########## FINDING FILES ############")
    print("#####################################")
    list_of_files = []
    file_names_dict_of_lists = {}
    for (dir_path, dir_names, file_names) in os.walk(path):
        for filename in file_names:
            if filename.endswith('.csv') or filename.endswith('.npy') or filename.endswith('.pth'):
                if filename not in file_names_dict_of_lists:
                    file_names_dict_of_lists[filename] = [os.path.join(dir_path, filename)]
                else:
                    file_names_dict_of_lists[filename] += [os.path.join(dir_path, filename)]
                list_of_files += [os.path.join(dir_path, filename)]
    print()
    for key in file_names_dict_of_lists:
        print(key)
        #print(file_names_dict_of_lists[key])


    print("\n#####################################")
    print("######## TABLE: RAW RESULTS #########")
    print("#####################################")
    data_frame_list = []
    for file in file_names_dict_of_lists['results_raw.csv']:
        data_frame_list.append(pd.read_csv(file))
    raw_results_data_frame = pd.concat(data_frame_list)
    #raw_results_data_frame.to_csv(os.path.join(path, 'all_results_raw.csv'), index=False)
    print(raw_results_data_frame[:30])


    print("\n#####################################")
    print("###### TABLE: BEST ACCURACIES #######")
    print("#####################################")
    data_frame_list = []
    for file in file_names_dict_of_lists['results_best.csv']:
        #df = pd.read_csv(file)
        #print(df)
        data_frame_list.append(pd.read_csv(file))
    best_results_data_frame = pd.concat(data_frame_list)
    best_results_data_frame.to_csv(os.path.join(path, 'all_results_best.csv'), index=False)
    #######################################################################################
    dfx = best_results_data_frame.loc[best_results_data_frame['DATA'].isin(EXTRA_DATASETS)]
    dfx.to_csv(os.path.join(path, 'extra_results_best.csv'), index=False)
    #######################################################################################
    #print(best_results_data_frame, "\n")
    for data in DATASETS:
    #for data in (DATASETS + EXTRA_DATASETS):
        for model in MODELS:
            print("\n########")
            print(data)
            print(model)
            df = best_results_data_frame.loc[
                best_results_data_frame['DATA'].isin([data]) &
                best_results_data_frame['MODEL'].isin([model])
            ]
            df = df.rename(columns={'VALID MAX_PROBS MEAN': 'MAX_PROBS', 'VALID ENTROPIES MEAN': 'ENTROPIES',
                                    'VALID INTRA_LOGITS MEAN': 'INTRA_LOGITS', 'VALID INTER_LOGITS MEAN': 'INTER_LOGITS'})
            df = df[[
                'LOSS',
                'TRAIN LOSS', 'TRAIN ACC1',
                'VALID LOSS', 'VALID ACC1', 'VALID ODD_ACC',
                'MAX_PROBS', 'ENTROPIES',
                'INTRA_LOGITS', 'INTER_LOGITS'
            ]]
            df = df.sort_values('VALID ACC1', ascending=False)#.drop_duplicates(["LOSS"])
            ##df.to_csv(os.path.join(path, data+'+'+model+'+results_best.csv'), index=False)
            #df = df.rename(columns={'VALID INTRA_LOGITS MEAN': 'VIALM', 'VALID INTER_LOGITS MEAN': 'VIELM'})
            print(df)
            print("########\n")


    print("\n#####################################")
    print("######## TABLE: ODD METRICS #########")
    print("#####################################")
    data_frame_list = []
    for file in file_names_dict_of_lists['results_odd.csv']:
        data_frame_list.append(pd.read_csv(file))
    best_results_data_frame = pd.concat(data_frame_list)
    best_results_data_frame.to_csv(os.path.join(path, 'all_results_odd.csv'), index=False)
    #######################################################################################
    dfx = best_results_data_frame.loc[best_results_data_frame['IN-DATA'].isin(EXTRA_DATASETS)]
    dfx.to_csv(os.path.join(path, 'extra_results_odd.csv'), index=False)
    #######################################################################################
    #print(best_results_data_frame, "\n")
    for data in DATASETS:
    #for data in (DATASETS + EXTRA_DATASETS):
        for model in MODELS:
            print("\n########")
            print(data)
            print(model)
            df = best_results_data_frame.loc[
                best_results_data_frame['IN-DATA'].isin([data]) &
                best_results_data_frame['MODEL'].isin([model]) &
                best_results_data_frame['INFER-LEARN'].isin(['NO']) &
                best_results_data_frame['SCORE'].isin(["MPS","ES","MIDS"]) &
                best_results_data_frame['AD-HOC'].isin(["NATIVE"]) &
                best_results_data_frame['OUT-DATA'].isin(['svhn','lsun_resize','imagenet_resize','cifar10'])
                ]
            df = df[['MODEL','IN-DATA','LOSS','AD-HOC','INFER-LEARN','SCORE','OUT-DATA','TNR','AUROC','DTACC','AUIN','AUOUT']]
            ################################################################################
            ################################################################################
            #df = df.groupby(['LOSS','AD-HOC','INFER-LEARN','SCORE'], as_index=False)['TNR'].mean()
            #df = df.sort_values(['TNR'], ascending=False)
            df = df.groupby(['LOSS','AD-HOC','INFER-LEARN','SCORE'], as_index=False)['AUROC'].mean()
            df = df.sort_values(['AUROC'], ascending=False)
            #df = df.sort_values(['LOSS','SCORE','OUT-DATA'], ascending=False)
            with pd.option_context('display.max_rows', None, 'display.max_columns', None):
                print(df)
            ################################################################################
            ################################################################################


