# machine unlearning for SFUDA
## Preliminary
To use the repository, we provide a conda environment.
```bash
conda update conda
conda env create -f environment.yml
conda activate sfa
```
- **Datasets**
To ensure consistency, we have provided labels for both the Office-31 and Office-Home datasets. You only need to download the dataset photos, of course, you need to ensure the consistency of the paths. We provide two types of TXT files for each dataset: one with labels for model training and testing, and another without labels for generating the pseudo-label dataset.
## Training
### Source
- For office-31, office-home, there is an example to training a source model :
```bash
CUDA_VISIBLE_DEVICES=0 python image_target_of_oh_vs.py --cfg "cfgs/office-home/source.yaml" SETTING.S 0
```
### Train the model using methods such as TPDS.
After obtaining the source models, modify the `${CKPT_DIR}` in the `conf.py` to your source model directory. For office-31, office-home, simply run the following Python file with the corresponding config file to execute source-free domain adaptation.
```bash
CUDA_VISIBLE_DEVICES=0 python image_target_of_oh_vs.py --cfg "cfgs/office-home/TPDS.yaml" SETTING.S 0 SETTING.T 1
```
### Add our method
In the image_target_of_oh_vs.py file, you can run our code by uncommenting line 75, and uncommenting line 76 will allow you to calculate the number of negative transfer samples.
You can enter the TPDS.machine(cfg) function to adjust the model's loading path and output path, modify the target domain category settings, and generate and load the corresponding pseudo-label dataset.

