

import matplotlib.pyplot as plt
import numpy as np
import pandas as pd

np.random.seed(10)
plt.rcParams['figure.dpi'] = 600

def compute_f(x0, x1, x2, x3, x4):
    return 0.1 * x0 * x1 + 0.5 * np.sin(x2 * x3) + np.sin(x4)


noise = 0.1
x = np.random.uniform(1.2, 1.8, 5)
f_values = []
N = 300  
N_noisy = int(N * 0.8)  
N_clean = N - N_noisy  


epsilon_noisy = np.random.normal(0, noise, N_noisy)

for i in range(N_noisy):
    f = compute_f(x[0], x[1], x[2], x[3], x[4]) + epsilon_noisy[i]
    f_values.append(f)
    x = np.roll(x, -1)
    x[-1] = f  

for i in range(N_clean):
    f = compute_f(x[0], x[1], x[2], x[3], x[4])
    f_values.append(f)
    
    x = np.roll(x, -1)
    x[-1] = f  


print("Generated f values:", f_values)
df = pd.DataFrame(f_values, columns=['f_values'])

plt.figure(figsize=(6, 4))
# plt.plot(df[:], color='dodgerblue', linewidth=2, linestyle='-')

plt.plot(range(N_noisy), f_values[:N_noisy], color='dodgerblue', linewidth=2, label='Training Set (Noisy)')
plt.plot(range(N_noisy, N), f_values[N_noisy:], color='limegreen', linewidth=2, label='Testing Set (Clean)')

ax = plt.gca()
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
plt.title(f'Noise = {noise} ', fontsize=12)
plt.legend(loc='upper left', fontsize=10)
plt.show()

df.to_csv(f'.csv', index=False)