#!/bin/bash


############################################################
# Input
############################################################
# DATE="20241018_1b_7b"
DATE="20241116_70b_72b_train_sz10"
ITERATION=5

# INPUT_FILE="exps/datasetgen/results/${DATE}/iter${ITERATION}/seed_dataset_iter${ITERATION}.json"
INPUT_FILE="exps/datasetgen/results/${DATE}/iter${ITERATION}/seed_dataset_iter${ITERATION}.json"

############################################################
# Model Names
############################################################
MODEL_NAME="mistralai/Pixtral-Large-Instruct-2411"
# MODEL_NAME="mistralai/Pixtral-12B-2409"
MODEL_NAME_SHORT=$(echo "${MODEL_NAME}" | tr '/' '\n' | tail -n 1)



############################################################
# VLLM
############################################################
TENSOR_PARALLEL_SIZE=8
VLLM_MAX_NUM_SEQS=64

############################################################
# Environment variables
############################################################
export PYTHONPATH="./:$PYTHONPATH"
export PYTHONPATH="src/:$PYTHONPATH"
export VLLM_WORKER_MULTIPROC_METHOD=spawn

############################################################
# Python environments
############################################################
PYTHON_VLLM="python"
PYTHON_TURTLE="python"
PYTHON_QWEN="python"


############################################################
# Postprocess
############################################################
POSTPROCESS_TYPE="success"


############################################################
# Prompt Template
############################################################





############################################################
# Prompt Files
############################################################
# prompt name
PROMPT_NAME="coderelabel"
PROMPT_TEMPLATE="src/turtlegfx_datagen/prompts/template_coderelabel.md"

# DIRs
PROMPTS_DIR="exps/datasetgen/results/${DATE}/iter${ITERATION}/${PROMPT_NAME}/prompts"
RESPONSES_DIR="exps/datasetgen/results/${DATE}/iter${ITERATION}/${PROMPT_NAME}/responses"
POSTPROCESS_DIR="exps/datasetgen/results/${DATE}/iter${ITERATION}/${PROMPT_NAME}/postprocess"

# prompt file
PROMPT_FILE="${PROMPTS_DIR}/prompts_${PROMPT_NAME}.json"
