import argparse
import json
from src.llmutils.create_jsonl_file_for_openai_batch_inference import write_jsonl_file
from src.turtlegfx_datagen.utils.img_utils import get_image_filename_from_id

def main(args):
    # load data
    requests = json.load(open(args.input_path, 'r'))

    # write to jsonl file
    write_jsonl_file(requests, args.output_path, args.model, args.max_tokens, args.temperature, args.top_p)

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--input_path", type=str, required=True)
    parser.add_argument("--output_path", type=str, required=True)
    parser.add_argument("--model", type=str, default="gpt-4o-2024-08-06")
    parser.add_argument("--max_tokens", type=int, default=1024)
    parser.add_argument("--temperature", type=float, default=0)
    parser.add_argument("--top_p", type=float, default=1)
    args = parser.parse_args()

    print(f"Input path: {args.input_path}")
    print(f"Output path: {args.output_path}")
    print(f"Model: {args.model}")
    print(f"Max tokens: {args.max_tokens}")
    print(f"Temperature: {args.temperature}")
    print(f"Top p: {args.top_p}")

    main(args)
