from src.turtlegfx.utils.base64img import save_base64_image
import json
import argparse
import os
from tqdm import tqdm

"""
Usage: 
python build_responses_diagnosis.py \
    --input_file <path/to/evaluations.json> \
    --output_dir <path/to/output_dir>
"""

def main(args):
    with open(args.input_file, 'r') as f:
        data = json.load(f)
    
    os.makedirs(args.output_dir, exist_ok=True)
    
    for item in tqdm(data['evaluations']):
        response_id = item['response_id']
        success = item['success']
        embedding_score = f"{item.get('embedding_score', 'unknown') * 100:.2f}" if isinstance(item.get('embedding_score'), (int, float)) else 'unknown'

        prefix = f"{response_id}_" if args.id_first else ""
        suffix = f"_{response_id}" if not args.id_first else ""

        if success:
            # convert base64 to image
            save_base64_image(
                item['image_output'], 
                f'{args.output_dir}/{prefix}success_{embedding_score}{suffix}_output.png'
            )
            save_base64_image(
                item['image_true'], 
                f'{args.output_dir}/{prefix}success_{embedding_score}{suffix}_true.png'
            )
        else:
            if 'image_output' in item \
                and item['image_output'] is not None \
                and 'image_true' in item \
                and item['image_true'] is not None:
                save_base64_image(
                    item['image_output'], 
                    f'{args.output_dir}/{prefix}fail_{embedding_score}{suffix}_output.png'
                )
                save_base64_image(
                    item['image_true'], 
                    f'{args.output_dir}/{prefix}fail_{embedding_score}{suffix}_true.png'
                )


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--input_file', type=str, default='exps/eval_vlms/results/evaluations/evaluations__dataset_graphics_sz721__nvlm_72b.json')
    parser.add_argument('--output_dir', type=str, default='exps/eval_vlms/results/evaluations_diagnosis/diagnosis__dataset_graphics_sz721__nvlm_72b')
    parser.add_argument('--id_first', action='store_true', help="Put id at the begining of the filename")
    args = parser.parse_args()

    main(args)
