#!/bin/bash

export PYTHONPATH="./:$PYTHONPATH"

# Define input parameters
INPUT_FILE="src/turtlegfx/data/graphics/dataset_graphics_sz823.json"
PROMPT_TEMPLATE="src/turtlegfx_datagen/prompts/template_code_synthesis.md"
OUTPUT_DIR="exps/eval_vlms/results/prompts"

# Define models array with correct names matching Python functions
models=(
    "aria"
    "blip2"
    "chameleon"
    "glm4v"
    "gpt"
    "idefics3"
    "internvl2"
    "llavaov_chat"
    "molmo"
    "nvlm"
    "paligemma"
    "phi3v"
    "pixtral"
    "pixtralhf"
    "qwen2vl_instruct"
    "deepseek_vl2"
)

# Loop through each model
for model in "${models[@]}"; do
    echo "Processing model: $model"
    # Extract the basename without extension from the input file
    base_name=$(basename "$INPUT_FILE" .json)
    output_file="${OUTPUT_DIR}/prompts__${base_name}__${model}.json"
    
    # if the output file exists, skip
    if [ -f ${output_file} ]; then
        echo "Skipping $model because ${output_file} exists"
    else
        python exps/eval_vlms/build_prompts.py \
            --input_file ${INPUT_FILE} \
            --output_file ${output_file} \
            --prompt_template ${PROMPT_TEMPLATE} \
            --model ${model} || echo "Failed to process $model"
    fi
    
    # if "gpt", then create a jsonl file for openai batch inference
    if [ "$model" == "gpt" ]; then
        # gpt-4o-2024-08-06
        output_file_gpt4o_20240806="${OUTPUT_DIR}/prompts__${base_name}__gpt-4o-2024-08-06.jsonl"
        if [ ! -f "${output_file_gpt4o_20240806}" ]; then
            python exps/eval_vlms/build_prompts_openai_create_batch.py \
                --input_path ${output_file} \
                --model "gpt-4o-2024-08-06" \
                --temperature 0 \
                --top_p 1 \
                --max_tokens 4096 \
                --output_path "${output_file_gpt4o_20240806}"
        fi

        # gpt-4o-2024-11-20
        output_file_gpt4o_20241120="${OUTPUT_DIR}/prompts__${base_name}__gpt-4o-2024-11-20.jsonl"
        if [ ! -f "${output_file_gpt4o_20241120}" ]; then
            python exps/eval_vlms/build_prompts_openai_create_batch.py \
                --input_path ${output_file} \
                --model "gpt-4o-2024-11-20" \
                --temperature 0 \
                --top_p 1 \
                --max_tokens 4096 \
                --output_path "${output_file_gpt4o_20241120}"
        fi

        # gpt-4-turbo-2024-04-09
        output_file_gpt4turbo="${OUTPUT_DIR}/prompts__${base_name}__gpt-4-turbo-2024-04-09.jsonl"
        if [ ! -f "${output_file_gpt4turbo}" ]; then
            python exps/eval_vlms/build_prompts_openai_create_batch.py \
                --input_path ${output_file} \
                --model "gpt-4-turbo-2024-04-09" \
                --temperature 0 \
                --top_p 1 \
                --max_tokens 4096 \
                --output_path "${output_file_gpt4turbo}"
        fi
    fi
done