import re
import argparse
import json
from src.turtlegfx_datagen.utils.extract_python import extract_python_code_from_text

def main(args):
    """
    Convert OpenAI JSONL output to Chat format.
    
    Example:
    JSONL:
    {"id": "...", "custom_id": "...", "response": {"body": {"...": "..."}}}

    Chat:
    {"id": "...", "src_file": "...", "object": "...", "created": "..."}
    """
    data = []
    with open(args.input_path, 'r') as f:
        for line in f:
            request = json.loads(line)
            body = request['response']['body']
            
            # Get generation parameters from the input if they exist
            gen_params = body.get('generation_parameters', {})
            output = {
                "id": f"{request['custom_id']}", 
                "src_file": args.input_path,
                "object": body.get('object'),
                "created": body.get('created'),
                "model": body.get('model'),
                "usage": {
                    "prompt_tokens": body.get('usage', {}).get('prompt_tokens'),
                    "completion_tokens": body.get('usage', {}).get('completion_tokens'),
                    "total_tokens": body.get('usage', {}).get('total_tokens'),
                },
                "choices": body.get('choices', []),
            }
            data.append(output)

    # save to file
    with open(args.output_path, 'w') as f:
        json.dump(data, f, ensure_ascii=False, indent=2)
    print(f"Saved to {args.output_path}")


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--input_path", type=str, default="exps/5_task_translation/results/batch_672a126736848190bfc3f6209264dcb4_output.jsonl")
    parser.add_argument("--output_path", type=str, default="exps/5_task_translation/results/gpt4o_translations.json")
    args = parser.parse_args()
    main(args)
