import pytest
from src.llmutils.extract_from_model_output import extract_from_model_output

def test_extract_json():
    content = """
    ```json
    {
        "key": "value"
    }
    ```
    """
    expected_output = {"key": "value"}
    result = extract_from_model_output(content, content_type='json')
    assert result == expected_output

def test_extract_python():
    # test 1
    content = """
    ```python
    def func():
        pass
    ```
    """
    expected_output = """
    def func():
        pass
    """
    result = extract_from_model_output(content, content_type='python')
    assert result.strip() == expected_output.strip()

    # test 2
    content = """
    This is a python code block:
    ```python
    def func():
        pass
    ```
    This is a json code block:
    ```json
    {
        "key": "value"
    }
    ```
    
    This is a markdown code block:
    ```markdown
    This is a markdown code block
    ```
    """
    expected_output = """
    def func():
        pass
    """
    result = extract_from_model_output(content, content_type='python')
    assert result.strip() == expected_output.strip()

def test_extract_markdown():
    # test 1
    content = """
    ```markdown
    hello
    ```
    """
    expected_output = "hello"
    result = extract_from_model_output(content, content_type='markdown')
    assert result.strip() == expected_output.strip()

    # test 2
    content = """
    ```markdown
    This is a test
    
    ```python
    def func():
        pass
    ```

    ```json
    {
        "key": "value"
    }
    ```
    Hello This is a test
    ```
    """
    expected_output = """
    This is a test
    
    ```python
    def func():
        pass
    ```

    ```json
    {
        "key": "value"
    }
    ```
    Hello This is a test
    """
    result = extract_from_model_output(content, content_type='markdown')
    assert result.strip() == expected_output.strip()

    # test 3
    content = """
    This is a test
    
    ```python
    def func():
        pass
    ```This is another test
    """

    expected_output = """"""
    result = extract_from_model_output(content, content_type='markdown')
    assert result.strip() == expected_output.strip()

