import json
import os


def load_code(code_id):
    assert code_id.startswith('midi_') or code_id.startswith('maxi_')
    base_path = os.path.dirname(os.path.abspath(__file__))

    if 'midi' in code_id:
        code_file = open(os.path.join(base_path, f'../data/midi/code/{code_id}.py'), 'r')
    elif 'maxi' in code_id:
        code_file = open(os.path.join(base_path, f'../data/maxi/code/{code_id}.py'), 'r')
    else:
        raise ValueError(f'Invalid code_id: {code_id}')
    code_str = code_file.read()
    return code_str


def load_task(task_id):
    assert task_id.startswith('midi_') or task_id.startswith('maxi_')
    level, id = task_id.split('_')  # midi or maxi

    base_path = os.path.dirname(os.path.abspath(__file__))
    if 'midi' in task_id:
        file = open(os.path.join(base_path, f'../data/midi/task/xlogomidi_task.json'), 'r')
    elif 'maxi' in task_id:
        file = open(os.path.join(base_path, f'../data/maxi/task/xlogomaxi_task.json'), 'r')
    else:
        raise ValueError(f'Invalid task_id: {task_id}')

    all_tasks = json.load(file)
    task_json = all_tasks[id]
    return task_json
