from enum import Enum


# Enum classes for different categories

class AddSpecs(Enum):
    # move
    SPEC_ADD_MOVE = "Modify the code to add some movements before or after the loop (if any)."
    SPEC_ADD_MOVE_INSIDE_LOOP = "Modify the code to add some movements inside the loop (if any)."

    # turn
    SPEC_ADD_TURN = "Modify the code to add some turns before or after the loop (if any)."
    SPEC_ADD_TURN_INSIDE_LOOP = "Modify the code to add some turns inside the loop (if any)."

    # loop
    SPEC_ADD_LOOP_INSIDE_LOOP = "Modify the code to introduce a nested loop within the existing loop, where each iteration of the inner loop draws a smaller shape or pattern."

    # color
    SPEC_ADD_COLOR_CHANGE = "Modify the code to add a color change before drawing each shape or line, cycling through a predefined set of colors."

    # effects
    SPEC_ADD_SPIRAL_MOVEMENT = "Modify the code to introduce a spiral movement in the turtle’s path before or after drawing each shape, creating a swirling effect."
    SPEC_ADD_SHADOW_EFFECT = "Modify the code to add a shadow effect to each shape by drawing a slightly offset duplicate of the shape in a darker color."


class RemoveSpecs(Enum):
    SPEC_REMOVE_INSIDE_LOOP = "Modify the code to remove some moves or turns inside the loop (if any)."
    SPEC_REMOVE_FINAL_MOVE = "Modify the code to remove any final move or turn commands after the pattern has been completed, leaving the turtle in its last position."
    SPEC_REMOVE_COLOR_FILL = "Modify the code to remove any color filling inside shapes, so that only the outlines of the shapes are drawn."
    SPEC_REMOVE_ALTERNATE_SHAPES = "Modify the code to remove every alternate shape or step in the loop, creating a more spaced-out pattern."
    SPEC_REMOVE_OUTER_BORDER = "Modify the code to remove any outer border or frame around the pattern, leaving only the central elements."
    SPEC_REMOVE_INTERSECTING_LINES = "Modify the code to remove any lines that intersect with other shapes, creating a cleaner, more minimalistic design."


class ScaleSpecs(Enum):
    SPEC_SCALEUP = "Modify the code so that all shapes are scaled up by a factor of 1.5, increasing their size by 50%."
    SPEC_SCALEUP_BY_2 = "Modify the code so that all shapes are scaled up by a factor of 2, doubling their size."
    SPEC_SCALEDOWN = "Modify the code so that all shapes are scaled down by a factor of 0.5, decreasing their size by 50%."
    SPEC_SCALEDOWN_BY_dot75 = "Modify the code so that all shapes are scaled down by a factor of 0.75, reducing their size by 25%."
    SPEC_SCALEUP_ALTERNATE_SHAPES = "Modify the code to scale up every alternate shape by a factor of 2, creating a pattern with alternating large and small shapes."
    SPEC_SCALE_HEIGHT_ONLY = "Modify the code so that only the height of all shapes is scaled by a factor of 1.5, making them taller while keeping the width the same."


class RotateSpecs(Enum):
    SPEC_ROTATE_CLOCKWISE_60 = "Adjust the code to rotate the entire drawing by 60 degrees clockwise after the pattern is drawn."
    SPEC_ROTATE_COUNTERCLOCKWISE_90 = "Adjust the code to rotate the entire drawing by 90 degrees counterclockwise after the pattern is drawn."
    SPEC_ROTATE_EACH_SHAPE_45 = "Modify the code so that each individual shape is rotated by 45 degrees clockwise before being drawn."
    SPEC_ROTATE_ENTIRE_PATTERN_30 = "Adjust the code to rotate the entire drawing by 30 degrees clockwise before the pattern is drawn, starting the drawing at a different angle."
    SPEC_ROTATE_EACH_SHAPE_COUNTERCLOCKWISE_15 = "Modify the code so that each individual shape is rotated 15 degrees counterclockwise before being drawn."


class MirrorSpecs(Enum):
    SPEC_MIRROR_HORIZONTAL = "Modify the code to create a mirrored version of the pattern along the horizontal axis."
    SPEC_MIRROR_VERTICAL = "Modify the code to create a mirrored version of the pattern along the vertical axis."
    SPEC_MIRROR_DIAGONAL = "Modify the code to create a mirrored version of the pattern along a diagonal axis, such as from the bottom-left to the top-right."
    SPEC_MIRROR_ALTERNATE_SHAPES = "Modify the code to mirror every alternate shape along the vertical axis, creating a pattern with alternating mirrored elements."
    SPEC_MIRROR_ENTIRE_PATTERN_DIAGONALLY = "Modify the code to mirror the entire pattern along a diagonal axis (e.g., top-right to bottom-left) after it has been drawn."


class TransformSpecs(Enum):
    SPEC_TRANSLATE_RIGHT = "Modify the code to translate (move) the entire pattern 100 pixels to the right after it is drawn."
    SPEC_TRANSLATE_UP = "Modify the code to translate (move) the entire pattern 50 pixels upwards after it is drawn."
    SPEC_REPEAT_PATTERN = "Modify the code to repeat the entire pattern three times in a row horizontally, with a small gap between each repetition."
    SPEC_CONVERT_TO_CIRCLE = "Modify the code to replace all straight lines with arcs that form a circular shape, maintaining the original pattern’s structure."
    SPEC_FLIP_SHAPES = "Modify the code to flip each individual shape vertically before it is drawn, while keeping their positions unchanged."
    SPEC_TRANSLATE_DIAGONALLY = "Modify the code to translate (move) the entire pattern 50 pixels diagonally (both right and up) after it is drawn."
    SPEC_REPEAT_PATTERN_VERTICALLY = "Modify the code to repeat the entire pattern three times vertically, with a small gap between each repetition."
    SPEC_INVERT_COLORS = "Modify the code to invert the colors of the pattern, swapping light colors with dark and vice versa."
    SPEC_DRAW_PATTERNS_INSIDE_SHAPES = "Modify the code to draw smaller, repeating patterns inside each shape, creating a textured or detailed effect."
    SPEC_OVERLAP_SHAPES = "Modify the code to overlap the shapes slightly by adjusting their positions closer to each other, creating a layered effect."
    SPEC_CONCENTRIC_SHAPES = "Modify the code to draw concentric versions of each shape, where each shape is drawn inside the previous one with decreasing size."
    SPEC_DRAW_ALONG_CURVE = "Modify the code so that the entire pattern is drawn along a curve, such as a circle or an ellipse, instead of in straight lines."
    SPEC_CREATE_RADIAL_PATTERN = "Modify the code to arrange all shapes radially around a central point, with each shape rotated and positioned evenly around the circle."
    SPEC_DRAW_IN_REVERSE_ORDER = "Modify the code to draw the entire pattern in reverse order, starting from the last step and ending with the first."
    SPEC_CHANGE_PEN_SIZE = "Modify the code to change the pen size dynamically as the pattern is drawn, gradually increasing or decreasing the line thickness."
    SPEC_COMBINE_PATTERNS = "Modify the code to combine two or more patterns together, overlaying them to create a composite design."
    SPEC_ADD_BORDER = "Modify the code to add a decorative border around the entire pattern, enclosing it within a frame."
