def extract_model_name(model_path: str) -> str:
    if "--" not in model_path:
        return model_path

    # Split the path by the separator "--" and get the relevant part
    parts = model_path.split("--")

    # The model name is typically the last part of the split path before "snapshots"
    # If the path is well-formed, the model name will be in the second-to-last part.
    if len(parts) > 2:
        return parts[-1].split("/")[0]
    else:
        raise ValueError(f"The provided path '{model_path}' does not match the expected format.")