#!/bin/bash



DATE="20241114_70b_72b_eval"
ITERATION=2

############################################################
# Model Names
############################################################
CODEGEN_MODEL_NAME="meta-llama/Llama-3.1-70B-Instruct"
CODESCORING_MODEL_NAME="Qwen/Qwen2-VL-72B-Instruct"

CODEGEN_MODEL_NAME_SHORT=$(echo "${CODEGEN_MODEL_NAME}" | tr '/' '\n' | tail -n 1)
CODESCORING_MODEL_NAME_SHORT=$(echo "${CODESCORING_MODEL_NAME}" | tr '/' '\n' | tail -n 1)

############################################################
# VLLM
############################################################
TENSOR_PARALLEL_SIZE=8
VLLM_MAX_NUM_SEQS=64

############################################################
# Debug
############################################################
DEBUG_MODE=false
PIPELINE="codegen codededup codescoring"

############################################################
# Seed File
############################################################
SEED_FILE_ITER0="src/turtlegfx/data/midi/dataset_midigfx_sz103.json"


############################################################
# Params: Code Generation
############################################################
BUILD_PROMPT_PYTHON_FILE="src/turtlegfx_datagen/codegen/build_prompts_inferred_spec.py"

# Code Edit
N_COMBINE=2
N_COMBS_SAMPLE=16

# Postprocess
POSTPROCESS_TYPE="success"


############################################################
# Params: Code Scoring
############################################################
TOP_PERCENTAGE=0.3

############################################################
# Params: Code Deduplication
############################################################
EPS=0.2
MIN_SAMPLES=2