#!/bin/bash

# Exit immediately if a command exits with a non-zero status
set -e
set -o pipefail

############################################################
# Environment variables
############################################################
export PYTHONPATH="./:$PYTHONPATH"
export PYTHONPATH="src/:$PYTHONPATH"
export VLLM_WORKER_MULTIPROC_METHOD=spawn



############################################################
# Python environments
############################################################
PYTHON_TURTLE="python"
PYTHON_QWEN="python"





############################################################
# Prompt Names
############################################################
# Only set if not already defined
if [ -z "$CODEGEN_PROMPT_NAME" ]; then
    CODEGEN_PROMPT_NAME="codeedit_inferred_spec"
fi
if [ -z "$CODESCORING_PROMPT_NAME" ]; then
    CODESCORING_PROMPT_NAME="codescoring_inferred_spec"
fi


############################################################
# Prompt Templates
############################################################
CODEGEN_PROMPT_TEMPLATE="src/turtlegfx_datagen/prompts/template_${CODEGEN_PROMPT_NAME}.md"
CODESCORING_PROMPT_TEMPLATE="src/turtlegfx_datagen/prompts/template_evalquality.md"



############################################################
# DIRs
############################################################
CODEGEN_PROMPTS_DIR="exps/datasetgen/results/${DATE}/iter${ITERATION}/codegen/prompts"
CODEGEN_RESPONSES_DIR="exps/datasetgen/results/${DATE}/iter${ITERATION}/codegen/responses"
CODEGEN_POSTPROCESS_DIR="exps/datasetgen/results/${DATE}/iter${ITERATION}/codegen/postprocess"

CODEDEDUP_DIR="exps/datasetgen/results/${DATE}/iter${ITERATION}/codededup"

CODESCORING_PROMPTS_DIR="exps/datasetgen/results/${DATE}/iter${ITERATION}/codescoring/prompts"
CODESCORING_RESPONSES_DIR="exps/datasetgen/results/${DATE}/iter${ITERATION}/codescoring/responses"
CODESCORING_POSTPROCESS_DIR="exps/datasetgen/results/${DATE}/iter${ITERATION}/codescoring/postprocess"


############################################################
# Prompt Files
############################################################
CODEGEN_PROMPT_FILE="${CODEGEN_PROMPTS_DIR}/prompts_${CODEGEN_PROMPT_NAME}.json"
CODESCORING_PROMPT_FILE="${CODESCORING_PROMPTS_DIR}/prompts_${CODESCORING_PROMPT_NAME}.json"