import base64
import io
from PIL import Image


def convert_img_to_base64(img):
    if isinstance(img, str):
        img = Image.open(img)
    buffer = io.BytesIO()
    img.save(buffer, format='PNG')
    base64_image = base64.b64encode(buffer.getvalue()).decode('utf-8')
    return 'data:image/png;base64,' + base64_image


def convert_base64_to_img(base64_image):
    """
    Convert a base64-encoded string (with or without data URL prefix) back to a PIL Image.
    """
    # If the base64 string contains the data URL prefix, strip it off
    if base64_image.startswith('data:image'):
        base64_image = base64_image.split(',')[1]

    # Decode the base64 string and open it as an image using PIL
    img = Image.open(io.BytesIO(base64.b64decode(base64_image))).convert('RGB')
    return img


def save_base64_image(base64_image, image_path):
    """
    Decode base64 image and save it as a PNG file.

    Args:
        base64_image (str): The base64-encoded image string.
        image_path (str): The path where the image will be saved.
    """
    if base64_image.startswith('data:image'):
        base64_image = base64_image.split(',')[1]

    try:
        image_data = base64.b64decode(base64_image)
        image = Image.open(io.BytesIO(image_data))
        image.save(image_path, format='PNG')
    except Exception as e:
        print(f"Error saving image to {image_path}: {e}")
        return None
