import json

"""
This file is used to convert the xlogoonline format (midi & max) to the format of our project.
"""


def convert_xlogoonlinemidi_to_xlogomidi():
    """
    Convert xlogoonline_midi.json and xlogoonline_midi_description.json to the format of our project
    """
    midi_tasks = json.load(open('../data/midi/task/xlogoonline_midi.json', 'r'))
    midi_desc = json.load(open('../data/midi/task/xlogoonline_midi_description.json', 'r'))

    all_fields = []

    e_jsons = {}
    for chap in midi_tasks['chapters']:
        chap_name = chap['name']
        chap_exercises = chap['exercises']
        for e in chap_exercises:
            all_fields.extend(e.keys())
            e_json = {}
            e_json['id'] = e['name']
            e_json['chapter'] = chap_name
            e_json['description'] = midi_desc[e['name']]
            e_json['lineSegments'] = e['lineSegments']
            for line in e_json['lineSegments']:
                # in xlogoonline format, the y-axis is inverted
                line['y1'] = -line['y1']
                line['y2'] = -line['y2']
            for label in e['labels']:
                label['y'] = -label['y']
            for rect in e['rectangles']:
                rect['y1'] = -rect['y1']
                rect['y2'] = -rect['y2']
            e_json['rectangles'] = e['rectangles']
            e_json['labels'] = e['labels']
            e_json['constraints'] = e['constraints']
            e_json['turtleData'] = e['turtleData']
            e_json['drawnImage'] = e['drawnImage']
            e_jsons[e_json['id']] = e_json
            if 'correctThreshold' in e:
                e_json['correctThreshold'] = e['correctThreshold']
    print(set(all_fields))
    json.dump(e_jsons, open('xlogomidi_task.json', 'w'), indent=2)


def convert_xlogoonlinemaxi_to_xlogomaxi():
    """
    Convert xlogoonline_maxi.json and xlogoonline_maxi_description.json to the format of our project
    """
    maxi_tasks = json.load(open('../data/maxi/task/xlogoonline_maxi.json', 'r'))
    maxi_desc = json.load(open('../data/maxi/task/xlogoonline_maxi_description.json', 'r'))

    all_fields = {'turtleData', 'points', 'rectangles', 'correctThreshold', 'labels', 'code', 'usedPrograms',
                  'drawnImage', 'name', 'constraints', 'lineSegments', 'description', 'showEditor'}

    e_jsons = {}
    for chap in maxi_tasks:
        chap_name = chap['name']
        chap_exercises = chap['exercises']
        for e in chap_exercises:
            e_json = {}
            e_json['id'] = chap_name + e['description']
            e_json['chapter'] = chap_name
            e_json['description'] = maxi_desc['maxi' + e_json['id']]
            e_json['lineSegments'] = e['lineSegments']
            for line in e_json['lineSegments']:
                # in xlogoonline format, the y-axis is inverted
                line['y1'] = -line['y1']
                line['y2'] = -line['y2']
            for label in e['labels']:
                label['y'] = -label['y']
            for rect in e['rectangles']:
                rect['y1'] = -rect['y1']
                rect['y2'] = -rect['y2']
            e_json['rectangles'] = e['rectangles']
            e_json['labels'] = e['labels']
            e_json['constraints'] = e['constraints']
            e_json['turtleData'] = e['turtleData']
            e_json['drawnImage'] = e['drawnImage']
            # only for maxi
            e_json['points'] = e['points']
            e_json['showEditor'] = e['showEditor']
            if 'correctThreshold' in e:
                e_json['correctThreshold'] = e['correctThreshold']
            if 'code' in e:
                e_json['code'] = e['code']
            if 'usedPrograms' in e:
                e_json['usedPrograms'] = e['usedPrograms']
            e_jsons[e_json['id']] = e_json
    print(set(all_fields))
    json.dump(e_jsons, open('xlogomaxi_task.json', 'w'), indent=2)


convert_xlogoonlinemidi_to_xlogomidi()
convert_xlogoonlinemaxi_to_xlogomaxi()
