from src.turtlegfx.utils.load_data import load_task, load_code
from src.turtlegfx.utils.enums import MIDI_TASKIDS
from src.turtlegfx.emulate.emulator import Executor
import json

if __name__ == "__main__":
    task_ids = MIDI_TASKIDS[:10]    # TODO: add more
    code_strs = [load_code(task_id) for task_id in task_ids]

    seed_dataset = []
    for task_id in task_ids:
        image, result = Executor().run(code=task_id, show_screen=False)
        item_data = {
            "id"      : task_id,
            "code"    : load_code(task_id),
            "task_image": image,
            "src_file": None
        }
        seed_dataset.append(item_data)

    with open("src/turtlegfx_datagen/codegen/data/seed_dataset.json", "w") as f:
        json.dump(seed_dataset, f)
