import json
import os
from src.turtlegfx.utils.base64img import convert_base64_to_img


def get_image_filename_from_id(id, extension='png'):
    """
    Get the image filename from the id.

    When saving images, there is a max length of the filename with 255 characters. The id is of the format <uuid1>--<uuid2>--<uuid3>--...--<uuidN>.
    To make the filename shorter, we only keep the first <uuid1> and last <uuidN> parts of the id.
    """
    assert isinstance(id, str)
    assert len(id.split('--')) >= 2 or len(id.split('--')) == 1, f"Invalid id: {id}"
    if extension is not None:
        img_filename = f"{id.split('--')[0]}--{id.split('--')[-1]}.{extension}"
    else:
        img_filename = f"{id.split('--')[0]}--{id.split('--')[-1]}"
    return img_filename