#!/bin/bash



############################################################
# small models (1b_7b)
############################################################

# DATE="20241018_1b_7b"
# ITERATION=3

# # Model Names
# CODEGEN_MODEL_NAME="meta-llama/Llama-3.2-1B-Instruct"
# CODESCORING_MODEL_NAME="Qwen/Qwen2-VL-7B-Instruct"


# DATE="20241018_1b_7b"
# ITERATION=3

# # Model Names
# CODEGEN_MODEL_NAME="meta-llama/Llama-3.2-1B-Instruct"
# CODESCORING_MODEL_NAME="Qwen/Qwen2-VL-7B-Instruct"

# # for 4 gpus
# TENSOR_PARALLEL_SIZE=4
# VLLM_MAX_NUM_SEQS=16


############################################################
# large models (70b_72b)
############################################################

DATE="20241018_70b_72b"
ITERATION=2

# Model Names
CODEGEN_MODEL_NAME="meta-llama/Llama-3.1-70B-Instruct"
CODESCORING_MODEL_NAME="Qwen/Qwen2-VL-72B-Instruct"

# for 8 gpus
TENSOR_PARALLEL_SIZE=8
VLLM_MAX_NUM_SEQS=64


############################################################
# Model Name Shorts
############################################################

DEBUG_MODE=false
PIPELINE="codegen codededup codescoring"
# PIPELINE="codegen codededup codescoring obtain_seed_dataset" # all
# PIPELINE="codegen codededup"
# PIPELINE="codegen codededup codescoring"

CODEGEN_MODEL_NAME_SHORT=$(echo "${CODEGEN_MODEL_NAME}" | tr '/' '\n' | tail -n 1)
CODESCORING_MODEL_NAME_SHORT=$(echo "${CODESCORING_MODEL_NAME}" | tr '/' '\n' | tail -n 1)


############################################################
# Seed File
############################################################
SEED_FILE_ITER0="exps/datasetgen/data/basic_shapes.json"



############################################################
# Params: Code Generation
############################################################
# Code Edit
N_COMBINE=2
N_COMBS_SAMPLE=64

# Postprocess
POSTPROCESS_TYPE="success"

############################################################
# Params: Code Scoring
############################################################
TOP_PERCENTAGE=0.8 # Code scoring (keep top-n% scored responses)

############################################################
# Params: Code Deduplication
############################################################
EPS=0.2
MIN_SAMPLES=2